import argparse

parser = argparse.ArgumentParser(description='oled arguments')
parser.add_argument(
    '--port', '-p',
    type=int,
    default=1,
    help='Numer magistrali i2c',
)
parser.add_argument(
    '--address', '-a',
    type=str,
    default='0x3c',
    help='Adres wyświetlacza i2c',
)
parser.add_argument(
    '--display', '-d',
    type=str,
    default='ssd1306',
    help='Typ wyświetlacza (ssd1306 lub sh1106)',
)

args = parser.parse_args()
if args.display not in ('ssd1306', 'sh1106'):
    parser.error('Nieznany wyświetlacz %s' % args.display)
try:
    args.address = int(args.address, 0)
except ValueError:
    parser.error('Błędny adres %s' % args.address)

import oled.device
Device = getattr(oled.device, args.display)
device = Device(port=args.port, address=args.address)
