
from urllib.request import urlopen
from bs4 import BeautifulSoup
import re
import random
from multiprocessing import Process, Queue
import os
import time


def task_delegator(taskQueue, foundUrlsQueue):
    #Inicjuje zadanie dla każdego procesu
    visited = ['/wiki/Kevin_Bacon', '/wiki/Monty_Python']
    taskQueue.put('/wiki/Kevin_Bacon')
    taskQueue.put('/wiki/Monty_Python')

    while 1:
        #Sprawdza, czy występują nowe odnośniki do przetwarzania w obiekcie urlsQueue
        if not foundUrlsQueue.empty():
            links = [link for link in foundUrlsQueue.get() if link not in visited]
            for link in links:
                #Dodaje nowy odnośnik do obiektu taskQueue
                taskQueue.put(link)
                #Dodaje nowy odnośnik do listy odwiedzonych
                visited.append(link)

def get_links(bsObj):
    links = bsObj.find('div', {'id':'bodyContent'}).find_all('a', href=re.compile('^(/wiki/)((?!:).)*$'))
    return [link.attrs['href'] for link in links]

def scrape_article(taskQueue, foundUrlsQueue):
    while 1:
        while taskQueue.empty():
            #Czeka 100 ms na kolejkę zadań 
            #Taka sytuacja powinna zdarzać się rzadko
            time.sleep(.1)
        path = taskQueue.get()
        html = urlopen('http://en.wikipedia.org{}'.format(path))
        time.sleep(5)
        bsObj = BeautifulSoup(html, 'html.parser')
        title = bsObj.find('h1').get_text()
        print('Ekstrakcja danych: {} w procesie {}'.format(title, os.getpid()))
        links = get_links(bsObj)
        #Wysyła je do delegata w celu przetwarzania
        foundUrlsQueue.put(links)


processes = []
taskQueue = Queue()
foundUrlsQueue = Queue()
processes.append(Process(target=task_delegator, args=(taskQueue, foundUrlsQueue,)))
processes.append(Process(target=scrape_article, args=(taskQueue, foundUrlsQueue,)))
processes.append(Process(target=scrape_article, args=(taskQueue, foundUrlsQueue,)))

for p in processes:
    p.start()
