// Nazwa pliku: ExtremeC_examples_chapter8_4_animal.c
// Opis: Definicja prywatna funkcji zachowania
//              klasy Animal.

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "ExtremeC_examples_chapter8_4_animal_p.h"

// Domyślna definicja funkcji animal_sound() na poziomie klasy nadrzędnej.
void __animal_sound(void* this_ptr) {
  animal_t* animal = (animal_t*)this_ptr;
  printf("%s: Beeeep\n", animal->name);
}

// Alokator pamięci.
animal_t* animal_new() {
  return (animal_t*)malloc(sizeof(animal_t));
}

// Konstruktor.
void animal_ctor(animal_t* animal) {
  animal->name = (char*)malloc(10 * sizeof(char));
  strcpy(animal->name, "Animal");
  // Zdefiniowanie wskaźnika funkcji prowadzącego do definicji domyślnej.
  animal->sound_func = __animal_sound;
}

// Destruktor.
void animal_dtor(animal_t* animal) {
  free(animal->name);
}

// Funkcje definiujące zachowanie.
void animal_get_name(animal_t* animal, char* buffer) {
  strcpy(buffer, animal->name);
}

void animal_sound(animal_t* animal) {
  // Wywołanie funkcji, do której prowadzi wskaźnik funkcji.
  animal->sound_func(animal);
}
