#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <pthread.h>

#include <sys/socket.h>
#include <sys/un.h>

#include <stream_server_core.h>

int main(int argc, char** argv) {
  char sock_file[] = "/tmp/calc_svc.sock";

  // ----------- 1. Utworzenie obiektu gniazda. ------------------
  int server_sd = socket(AF_UNIX, SOCK_STREAM, 0);
  if (server_sd == -1) {
    fprintf(stderr, "Nie udało się utworzyć gniazda: %s\n",
            strerror(errno));
    exit(1);
  }

  // ----------- 2. Dołączenie pliku gniazda. ------------------

  // Usunięcie poprzednio utworzonego pliku gniazda, o ile taki istnieje.
  unlink(sock_file);

  // Przygotowanie adresu.
  struct sockaddr_un addr;
  memset(&addr, 0, sizeof(addr));
  addr.sun_family = AF_UNIX;
  strncpy(addr.sun_path, sock_file, sizeof(addr.sun_path) - 1);

  int result = bind(server_sd,
          (struct sockaddr*)&addr, sizeof(addr));
  if (result == -1) {
    close(server_sd);
    fprintf(stderr, "Nie udało się dołączyć adresu: %s\n",
            strerror(errno));
    exit(1);
  }

  // ----------- 3. Przygotowanie kolejki zbioru zadań przeznaczonych do wykonania. ------------------
  result = listen(server_sd, 10);
  if (result == -1) {
    close(server_sd);
    fprintf(stderr, "Nie udało się zdefiniować wielkości kolejki zbioru zadań przeznaczonych do wykonania: %s\n",
            strerror(errno));
    exit(1);
  }

  // ----------- 4. Rozpoczęcie akceptowania klientów. ---------
  accept_forever(server_sd);

  return 0;
}
