// Nazwa pliku: ExtremeC_examples_chapter19_2.c
// Opis: Przykład użycia potoku POSIX

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>

int main(int argc, char** argv) {
  int fds[2];
  pipe(fds);

  int childpid = fork();
  if (childpid == -1) {
    fprintf(stderr, "Błąd podczas wywołania fork()!\n");
    exit(1);
  }
  if (childpid == 0) {
    // Proces potomny zamyka deskryptora pliku przeznaczonego do odczytywania danych.
    close(fds[0]);
    char str[] = "Witaj, tato!";
    // Proces potomny zapisuje dane do deskryptora pliku przeznaczonego do zapisywania danych.
    fprintf(stdout, "POTOMNY: Oczekiwanie przez dwie sekundy...\n");
    sleep(2);
    fprintf(stdout, "POTOMNY: Zapisywanie danych...\n");
    write(fds[1], str, strlen(str) + 1);
  } else {
    // Proces nadrzędny zamyka deskryptora pliku przeznaczonego do zapisywania danych.
    close(fds[1]);
    char buff[32];
    // Proces nadrzędny odczytuje dane z deskryptora pliku przeznaczonego do odczytywania danych.
    fprintf(stdout, "NADRZĘDNY: Odczytywanie danych z procesu potomnego...\n");
    int num_of_read_bytes = read(fds[0], buff, 32);
    fprintf(stdout, "NADRZĘDNY: Oto dane otrzymane z procesu potomnego: %s\n", buff);
  }
  return 0;
}
