// Nazwa pliku: ExtremeC_examples_chapter8_2_main.c
// Opis: Implementacja funkcji main().

#include <stdio.h>
#include <stdlib.h>

#include "ExtremeC_examples_chapter8_2_person.h"
#include "ExtremeC_examples_chapter8_2_student.h"

int main(int argc, char** argv) {
  // Utworzenie obiektu klasy student.
  struct student_t* student = student_new();
  student_ctor(student, "Jan", "Kowalski",
          1987, "TA5667", 134);

  // Teraz użyjemy funkcji zachowania klasy person w celu
  // odczytania atrybutów obiektu person z obiektu student.
  char buffer[32];

  // Rzutowanie w górę do wskaźnika typu nadrzędnego.
  struct person_t* person_ptr = (struct person_t*)student;

  person_get_first_name(person_ptr, buffer);
  printf("Imię: %s\n", buffer);

  person_get_last_name(person_ptr, buffer);
  printf("Nazwisko: %s\n", buffer);

  printf("Rok urodzenia: %d\n", person_get_birth_year(person_ptr));

  // Teraz odczytywane są atrybuty związane z obiektem student.
  student_get_student_number(student, buffer);
  printf("Identyfikator: %s\n", buffer);

  printf("Zaliczenia: %d\n",
          student_get_passed_credits(student));

  // Usunięcie obiektu student i zwolnienie zajmowanej przez niego pamięci.
  student_dtor(student);
  free(student);

  return 0;
}
