#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
rate = 1.45
seconds = 3 * 60 + 42
cost = rate * seconds / 60
print(cost)


print("Przykład 2")
print(round(cost, 2))


print("Przykład 3")
from decimal import Decimal

rate = Decimal("1.45")
seconds = Decimal(3 * 60 + 42)
cost = rate * seconds / Decimal(60)
print(cost)


print("Przykład 4")
print(Decimal("1.45"))
print(Decimal(1.45))


print("Przykład 5")
print("456")
print(456)


print("Przykład 6")
rate = Decimal("0.05")
seconds = Decimal("5")
small_cost = rate * seconds / Decimal(60)
print(small_cost)


print("Przykład 7")
print(round(small_cost, 2))


print("Przykład 8")
from decimal import ROUND_UP

rounded = cost.quantize(Decimal("0.01"), rounding=ROUND_UP)
print(f"Kwota {cost} po zaokrągleniu wynosi {rounded}")


print("Przykład 9")
rounded = small_cost.quantize(Decimal("0.01"), rounding=ROUND_UP)
print(f"Kwota {small_cost} po zaokrągleniu wynosi {rounded}")
