#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2024 Brett Slatkin, Pearson Education Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

### Początek sekcji konfiguracji środowiska
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Zapisywanie wszystkich danych wyjściowych w katalogu tymczasowym
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Eleganckie zakończenie procesów systemu Windows
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)
### Koniec sekcji konfiguracji środowiska


print("Przykład 1")
from urllib.parse import parse_qs

my_values = parse_qs("red=5&blue=0&green=", keep_blank_values=True)
print(repr(my_values))


print("Przykład 2")
print("Czerwony:    ", my_values.get("red"))
print("Zielony:  ", my_values.get("green"))
print("Kryce:", my_values.get("opacity"))


print("Przykład 3")
# Kod dotyczy ciągu tekstowego zapytania 'red=5&blue=0&green='
red = my_values.get("red", [""])[0] or 0
green = my_values.get("green", [""])[0] or 0
opacity = my_values.get("opacity", [""])[0] or 0
print(f"Czerwony:     {red!r}")
print(f"Zielony:   {green!r}")
print(f"Kryce: {opacity!r}")


print("Przykład 4")
red = int(my_values.get("red", [""])[0] or 0)
green = int(my_values.get("green", [""])[0] or 0)
opacity = int(my_values.get("opacity", [""])[0] or 0)
print(f"Czerwony:     {red!r}")
print(f"Zielony:   {green!r}")
print(f"Kryce: {opacity!r}")


print("Przykład 5")
red_str = my_values.get("red", [""])
red = int(red_str[0]) if red_str[0] else 0
green_str = my_values.get("green", [""])
green = int(green_str[0]) if green_str[0] else 0
opacity_str = my_values.get("opacity", [""])
opacity = int(opacity_str[0]) if opacity_str[0] else 0
print(f"Czerwony:     {red!r}")
print(f"Zielony:   {green!r}")
print(f"Kryce: {opacity!r}")


print("Przykład 6")
green_str = my_values.get("green", [""])
if green_str[0]:
    green = int(green_str[0])
else:
    green = 0
print(f"Zielony:   {green!r}")


print("Przykład 7")
def get_first_int(values, key, default=0):
    found = values.get(key, [""])
    if found[0]:
        return int(found[0])
    return default


print("Przykład 8")
green = get_first_int(my_values, "green")
print(f"Zielony:   {green!r}")
