#!/usr/bin/env PYTHONHASHSEED=1234 python3

# Copyright 2014-2019 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import random
random.seed(1234)

import logging
from pprint import pprint
from sys import stdout as STDOUT

# Wygenerowanie wszystkich danych wyjściowych w katalogu tymczasowym.
import atexit
import gc
import io
import os
import tempfile

TEST_DIR = tempfile.TemporaryDirectory()
atexit.register(TEST_DIR.cleanup)

# Prawidłowe zakończenie procesów w systemie Windows.
OLD_CWD = os.getcwd()
atexit.register(lambda: os.chdir(OLD_CWD))
os.chdir(TEST_DIR.name)

def close_open_files():
    everything = gc.get_objects()
    for obj in everything:
        if isinstance(obj, io.IOBase):
            obj.close()

atexit.register(close_open_files)


# Przykład 1.
counters = {
    'pumpernikiel': 2,
    'na zakwasie': 1,
}


# Przykład 2.
key = 'pszenny'

if key in counters:
    count = counters[key]
else:
    count = 0

counters[key] = count + 1

print(counters)


# Przykład 3.
key = 'brioszka'

try:
    count = counters[key]
except KeyError:
    count = 0

counters[key] = count + 1

print(counters)


# Przykład 4.
key = 'wielozbożowy'

count = counters.get(key, 0)
counters[key] = count + 1

print(counters)


# Przykład 5.
key = 'bagietka'

if key not in counters:
    counters[key] = 0
counters[key] += 1

key = 'ciabata'

if key in counters:
    counters[key] += 1
else:
    counters[key] = 1

key = 'ciabata'

try:
    counters[key] += 1
except KeyError:
    counters[key] = 1

print(counters)


# Przykład 6.
votes = {
    'bagietka': ['Bartek', 'Alicja'],
    'ciabata': ['Celina', 'Dorota'],
}

key = 'brioszka'
who = 'Ela'

if key in votes:
    names = votes[key]
else:
    votes[key] = names = []

names.append(who)
print(votes)


# Przykład 7.
key = 'żytni'
who = 'Franek'

try:
    names = votes[key]
except KeyError:
    votes[key] = names = []

names.append(who)

print(votes)


# Przykład 8.
key = 'pszenny'
who = 'Gertruda'

names = votes.get(key)
if names is None:
    votes[key] = names = []

names.append(who)

print(votes)


# Przykład 9.
key = 'brioszka'
who = 'Hubert'

if (names := votes.get(key)) is None:
    votes[key] = names = []

names.append(who)

print(votes)


# Przykład 10.
key = 'kukurydziany'
who = 'Krzysztof'

names = votes.setdefault(key, [])
names.append(who)

print(votes)


# Przykład 11.
data = {}
key = 'foo'
value = []
data.setdefault(key, value)
print('Przed:', data)
value.append('witaj')
print('Po: ', data)


# Przykład 12.
key = 'chleb tygrysi'

count = counters.setdefault(key, 0)
counters[key] = count + 1

print(counters)
