/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeyFrames;
import org.jdesktop.animation.timing.interpolation.KeySplines;
import org.jdesktop.animation.timing.interpolation.KeyValues;
import org.jdesktop.animation.timing.interpolation.Spline;

public class PropertyRange {
    private String propertyName;
    private KeyFrames keyFrames;

    public PropertyRange(String propertyName, KeyFrames keyFrames) {
        this.propertyName = propertyName;
        this.keyFrames = keyFrames;
    }

    public static PropertyRange createPropertyRangeInt(String propertyName, int ... values) {
        KeyValues keyValues = KeyValues.createKeyValues(values);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeInt(String propertyName, Spline interpolation, int from, int to) {
        KeyValues keyValues = KeyValues.createKeyValues(from, to);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(interpolation));
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeFloat(String propertyName, float ... values) {
        KeyValues keyValues = KeyValues.createKeyValues(values);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeFloat(String propertyName, Spline interpolation, float from, float to) {
        KeyValues keyValues = KeyValues.createKeyValues(from, to);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(interpolation));
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeDouble(String propertyName, double ... values) {
        KeyValues keyValues = KeyValues.createKeyValues(values);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeDouble(String propertyName, Spline interpolation, double from, double to) {
        KeyValues keyValues = KeyValues.createKeyValues(from, to);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(interpolation));
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangePoint(String propertyName, Point ... values) {
        KeyValues keyValues = KeyValues.createKeyValues(values);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangePoint(String propertyName, Spline interpolation, Point from, Point to) {
        KeyValues keyValues = KeyValues.createKeyValues(from, to);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(interpolation));
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeDimension(String propertyName, Dimension ... values) {
        KeyValues keyValues = KeyValues.createKeyValues(values);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeDimension(String propertyName, Spline interpolation, Dimension from, Dimension to) {
        KeyValues keyValues = KeyValues.createKeyValues(from, to);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(interpolation));
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeRectangle(String propertyName, Rectangle ... values) {
        KeyValues keyValues = KeyValues.createKeyValues(values);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeRectangle(String propertyName, Spline interpolation, Rectangle from, Rectangle to) {
        KeyValues keyValues = KeyValues.createKeyValues(from, to);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(interpolation));
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeColor(String propertyName, Color ... values) {
        KeyValues keyValues = KeyValues.createKeyValues(values);
        KeyFrames keyFrames = new KeyFrames(keyValues);
        return new PropertyRange(propertyName, keyFrames);
    }

    public static PropertyRange createPropertyRangeColor(String propertyName, Spline interpolation, Color from, Color to) {
        KeyValues keyValues = KeyValues.createKeyValues(from, to);
        KeyFrames keyFrames = new KeyFrames(keyValues, new KeySplines(interpolation));
        return new PropertyRange(propertyName, keyFrames);
    }

    String getPropertyName() {
        return this.propertyName;
    }

    void setStartValue(Object object) {
        this.keyFrames.getKeyValues().setStartValue(object);
    }

    void setValue(Object object, Method method, float fraction) {
        this.keyFrames.setValue(object, method, fraction);
    }

    Class getType() {
        return this.keyFrames.getType();
    }
}

