/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public class ReflectionPanel
extends JPanel {
    private JPanel contentPane;
    private BufferedImage contentBuffer;
    private BufferedImage reflectionBuffer;
    private Graphics2D contentGraphics;
    private Graphics2D reflectionGraphics;
    private GradientPaint alphaMask;
    private float length = 0.65f;
    private float opacity = 0.75f;
    private boolean initialized = false;

    public ReflectionPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.buildContentPane();
        this.buildFiller();
        this.installRepaintManager();
        this.initialized = true;
    }

    private void installRepaintManager() {
        ReflectionRepaintManager manager = new ReflectionRepaintManager();
        RepaintManager.setCurrentManager(manager);
    }

    private void buildContentPane() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setOpaque(false);
        this.add((Component)this.contentPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void buildFiller() {
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void paint(Graphics g) {
        this.paintContent(g);
        this.paintReflection(g);
    }

    private void paintReflection(Graphics g) {
        int width = this.contentPane.getWidth();
        int height = (int)((float)this.contentPane.getHeight() * this.length);
        this.createReflection(g, width, height);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.scale(1.0, -1.0);
        g2.drawImage((Image)this.reflectionBuffer, 0, -this.contentPane.getHeight() - height, null);
        g2.dispose();
    }

    private void createReflection(Graphics g, int width, int height) {
        if (this.reflectionBuffer == null || this.reflectionBuffer.getWidth() != width || this.reflectionBuffer.getHeight() != height) {
            if (this.reflectionBuffer != null) {
                this.reflectionBuffer.flush();
                this.reflectionGraphics.dispose();
            }
            this.reflectionBuffer = GraphicsUtilities.createCompatibleImage(this.contentBuffer, width, height);
            this.reflectionGraphics = this.reflectionBuffer.createGraphics();
            this.alphaMask = new GradientPaint(0.0f, 0.0f, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f, height, new Color(0.0f, 0.0f, 0.0f, this.opacity), true);
        }
        int yOffset = this.contentPane.getHeight() - height;
        Rectangle clip = g.getClipBounds();
        Graphics2D g2 = this.reflectionGraphics;
        g2.setClip(clip.x, clip.y - yOffset, clip.width, clip.height);
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(clip.x, clip.y - yOffset, clip.width, clip.height);
        g2.setComposite(AlphaComposite.SrcOver);
        g2.translate(0, -yOffset);
        g2.drawImage((Image)this.contentBuffer, 0, 0, null);
        g2.translate(0, yOffset);
        g2.setComposite(AlphaComposite.DstIn);
        g2.setPaint(this.alphaMask);
        g2.fillRect(clip.x, clip.y - yOffset, clip.width, clip.height);
    }

    private void paintContent(Graphics g) {
        if (this.contentBuffer == null || this.contentBuffer.getWidth() != this.contentPane.getWidth() || this.contentBuffer.getHeight() != this.contentPane.getHeight()) {
            if (this.contentBuffer != null) {
                this.contentBuffer.flush();
                this.contentGraphics.dispose();
            }
            this.contentBuffer = GraphicsUtilities.createCompatibleTranslucentImage(this.contentPane.getWidth(), this.contentPane.getHeight());
            this.contentGraphics = this.contentBuffer.createGraphics();
        }
        Graphics2D g2 = this.contentGraphics;
        g2.clipRect(this.contentPane.getX(), this.contentPane.getY(), this.contentPane.getWidth(), this.contentPane.getHeight());
        g2.setComposite(AlphaComposite.Clear);
        Rectangle clip = g.getClipBounds();
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        g2.setComposite(AlphaComposite.SrcOver);
        g2.setColor(g.getColor());
        g2.setFont(g.getFont());
        super.paint(g2);
        g.drawImage(this.contentBuffer, 0, 0, null);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.initialized) {
            this.contentPane.add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public Dimension getPreferredSize() {
        Dimension size = this.contentPane.getPreferredSize();
        size.height = (int)((float)size.height * (1.0f + this.length));
        return size;
    }

    public void remove(int index) {
        this.contentPane.remove(index);
    }

    public void remove(Component comp) {
        this.contentPane.remove(comp);
    }

    public void removeAll() {
        this.contentPane.removeAll();
    }

    public void setLayout(LayoutManager mgr) {
        if (this.initialized) {
            this.contentPane.setLayout(mgr);
        } else {
            super.setLayout(mgr);
        }
    }

    private class ReflectionRepaintManager
    extends RepaintManager {
        private ReflectionRepaintManager() {
        }

        public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            Rectangle dirtyRegion = this.getDirtyRegion(c);
            int lastDeltaX = c.getX();
            int lastDeltaY = c.getY();
            Container parent = c.getParent();
            while (parent instanceof JComponent) {
                if (!parent.isVisible()) {
                    return;
                }
                if (parent instanceof ReflectionPanel) {
                    x += lastDeltaX;
                    int gap = ReflectionPanel.this.contentPane.getHeight() - h - (y += lastDeltaY);
                    h += 2 * gap + h;
                    lastDeltaY = 0;
                    lastDeltaX = 0;
                    c = (JComponent)parent;
                }
                lastDeltaX += parent.getX();
                lastDeltaY += parent.getY();
                parent = parent.getParent();
            }
            super.addDirtyRegion(c, x, y, w, h);
        }
    }
}

