/*
 * Decompiled with CFR 0.152.
 */
package org.progx.artemis.ui;

import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.interpolation.ObjectModifier;
import org.jdesktop.animation.timing.interpolation.PropertyRange;
import org.progx.artemis.Application;
import org.progx.artemis.ui.DoneStepPanel;
import org.progx.artemis.ui.DragAndDropStepPanel;
import org.progx.artemis.ui.GradientPanel;
import org.progx.artemis.ui.ImageTransferHandler;
import org.progx.artemis.ui.ProgressGlassPane;
import org.progx.artemis.ui.SizeStepPanel;
import org.progx.artemis.ui.StepLabel;

public class MainFrame
extends JFrame {
    private StepLabel stepLabel;
    private BufferedImage image;
    private ProgressGlassPane waitPanel;
    private TimingController timer;
    private SizeStepPanel sizeStep;
    private DragAndDropStepPanel dragAndDropStep;
    private DoneStepPanel doneStep;
    private String fileName;

    public MainFrame() {
        super(Application.getResourceBundle().getString("frame.title"));
        this.setContentPane(new GradientPanel());
        this.waitPanel = new ProgressGlassPane();
        this.setGlassPane(this.waitPanel);
        this.buildContentPane();
        this.setDefaultCloseOperation(3);
        this.setSize(640, 480);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    private void buildContentPane() {
        this.buildStepLabel();
        this.add((Component)this.stepLabel, "South");
        this.showDragAndDropStep();
    }

    private void buildStepLabel() {
        this.stepLabel = new StepLabel();
        this.stepLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 36, 0));
    }

    public void showDragAndDropStep() {
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        if (this.sizeStep != null) {
            this.remove(this.sizeStep);
            this.sizeStep = null;
        } else if (this.doneStep != null) {
            this.remove(this.doneStep);
            this.doneStep = null;
        }
        this.dragAndDropStep = new DragAndDropStepPanel();
        this.dragAndDropStep.setTransferHandler(new ImageTransferHandler());
        this.add(this.dragAndDropStep);
        this.setStepInfo(1, Application.getResourceBundle().getString("step.1.dropHere"));
        this.hideWaitGlassPane();
    }

    private void setStepInfo(int step, String message) {
        this.stepLabel.setStep(step);
        this.stepLabel.setText(message);
    }

    public void setImage(BufferedImage image, String fileName) {
        this.fileName = fileName;
        this.image = image;
        this.showSizeStep();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    private void showSizeStep() {
        this.sizeStep = new SizeStepPanel();
        this.remove(this.dragAndDropStep);
        this.dragAndDropStep = null;
        this.add(this.sizeStep);
        this.setStepInfo(2, Application.getResourceBundle().getString("step.2.chooseSize"));
    }

    public void showWaitGlassPane() {
        Cycle cycle = new Cycle(2500, 33);
        Envelope envelope = new Envelope(-1.0, 0, Envelope.RepeatBehavior.REVERSE, Envelope.EndBehavior.HOLD);
        PropertyRange fadeRange = PropertyRange.createPropertyRangeInt("progress", 0, 100);
        this.timer = new TimingController(cycle, envelope, new ObjectModifier(this.waitPanel, fadeRange));
        this.waitPanel.setProgress(0);
        this.waitPanel.setVisible(true);
        this.timer.start();
    }

    public void hideWaitGlassPane() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.waitPanel.setVisible(false);
    }

    public void showDoneStep() {
        this.doneStep = new DoneStepPanel();
        this.remove(this.sizeStep);
        this.sizeStep = null;
        this.add(this.doneStep);
        this.setStepInfo(3, Application.getResourceBundle().getString("step.3.done"));
        this.hideWaitGlassPane();
    }

    public String getFileName() {
        return this.fileName;
    }
}

