/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.TransferHandler;
import org.jdesktop.layout.GroupLayout;

public class ApplicationFrame
extends JFrame {
    private PictureGlassPane glassPane = new PictureGlassPane();
    private JList imageList;
    private JScrollPane listScroller;

    public ApplicationFrame() {
        this.setContentPane(new JPanel(new BorderLayout()){
            private BufferedImage image;
            {
                this.image = null;
            }

            @Override
            public boolean isOpaque() {
                return ApplicationFrame.this.imageList.getModel().getSize() > 0;
            }

            @Override
            protected void paintComponent(Graphics g) {
                Rectangle clip = g.getClipBounds();
                g.setColor(Color.WHITE);
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
                if (this.image == null) {
                    try {
                        this.image = ImageIO.read(this.getClass().getResource("images/drop-here.png"));
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                g.drawImage(this.image, (this.getWidth() - this.image.getWidth()) / 2, (this.getHeight() - this.image.getHeight()) / 2, null);
            }
        });
        this.initComponents();
        this.imageList.setOpaque(false);
        this.listScroller.setOpaque(false);
        this.listScroller.getViewport().setOpaque(false);
        this.setGlassPane(this.glassPane);
        this.imageList.setModel(new DefaultListModel());
        this.imageList.setTransferHandler(new FileDropHandler());
        this.imageList.addPropertyChangeListener("dropLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ApplicationFrame.this.glassPane.moveIt(MouseInfo.getPointerInfo().getLocation());
            }
        });
    }

    private void initComponents() {
        this.listScroller = new JScrollPane();
        this.imageList = new JList();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JSeparator jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(3);
        this.setTitle("Przeci\u0105gnij i upu\u015b\u0107");
        this.imageList.setSelectionMode(0);
        this.imageList.setLayoutOrientation(2);
        this.imageList.setVisibleRowCount(-1);
        this.listScroller.setViewportView(this.imageList);
        jPanel1.setBackground(new Color(255, 255, 255));
        jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/images/app-icon.png")));
        jLabel2.setFont(jLabel2.getFont().deriveFont(jLabel2.getFont().getStyle() | 1, jLabel2.getFont().getSize() + 2));
        jLabel2.setText("Przeci\u0105gnij i upu\u015b\u0107 na szklanym panelu");
        jLabel3.setText("Przeci\u0105gnij i wrzu\u0107 pliki obraz\u00f3w (PNG lub JPEG) do aplikacji.");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jLabel1).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(jLabel2).add(jLabel3)).addContainerGap(269, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jLabel2).addPreferredGap(0).add(jLabel3)).add(jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(jPanel1, -1, -1, Short.MAX_VALUE).add(jSeparator1, -1, 618, Short.MAX_VALUE).add(layout.createSequentialGroup().addContainerGap().add(this.listScroller, -1, 598, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(jPanel1, -2, -1, -2).add(0, 0, 0).add(jSeparator1, -2, 10, -2).addPreferredGap(0).add(this.listScroller, -1, 372, Short.MAX_VALUE).addContainerGap()));
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ApplicationFrame().setVisible(true);
            }
        });
    }

    class FileDropHandler
    extends TransferHandler {
        private boolean imported = false;
        private List<File> fileList;

        FileDropHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean copySupported;
            if (!support.isDrop()) {
                return false;
            }
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            boolean bl = copySupported = (1 & support.getSourceDropActions()) == 1;
            if (copySupported) {
                support.setDropAction(1);
                if (!this.imported) {
                    Transferable t = support.getTransferable();
                    try {
                        Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
                        this.fileList = (List)data;
                        BufferedImage image = this.createImage(this.fileList);
                        if (image != null) {
                            Point p = MouseInfo.getPointerInfo().getLocation();
                            ApplicationFrame.this.glassPane.showIt(image, p);
                            this.imported = true;
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        private BufferedImage createImage(List<File> files) {
            ArrayList<File> imageFiles = new ArrayList<File>(3);
            for (File file : files) {
                if (!file.getName().endsWith(".png") && !file.getName().endsWith(".jpg")) continue;
                imageFiles.add(file);
                if (imageFiles.size() != 3) continue;
                break;
            }
            if (imageFiles.size() == 0) {
                return null;
            }
            int width = 60 + (imageFiles.size() - 1) * 10;
            int height = 45 + (imageFiles.size() - 1) * 10;
            BufferedImage image = GraphicsUtilities.createCompatibleTranslucentImage(width, height);
            Graphics2D g2 = image.createGraphics();
            for (int i = 0; i < imageFiles.size(); ++i) {
                File imageFile = (File)imageFiles.get(i);
                BufferedImage externalImage = null;
                try {
                    externalImage = GraphicsUtilities.loadCompatibleImage(imageFile.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                externalImage = GraphicsUtilities.createThumbnail(externalImage, 60, 45);
                g2.drawImage((Image)externalImage, i * 10, i * 10, null);
            }
            g2.dispose();
            return image;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            for (int i = 0; i < this.fileList.size(); ++i) {
                File imageFile = this.fileList.get(i);
                BufferedImage externalImage = null;
                try {
                    externalImage = GraphicsUtilities.loadCompatibleImage(imageFile.toURI().toURL());
                    externalImage = GraphicsUtilities.createThumbnail(externalImage, 120);
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                ((DefaultListModel)ApplicationFrame.this.imageList.getModel()).add(0, new ImageIcon(externalImage));
            }
            ApplicationFrame.this.glassPane.hideIt();
            this.imported = false;
            return true;
        }
    }
}

