/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AlphaCompositesApplication
extends JFrame {
    private CompositePainter painter = new CompositePainter();
    private JSlider opacity;
    private JComboBox composites;

    public AlphaCompositesApplication() {
        super("Mieszanie Alfa");
        this.add((Component)this.painter, "Center");
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.add(this.buildCompositeSelector());
        panel.add(this.buildOpacitySelector());
        this.add((Component)panel, "South");
        this.setSize(400, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    private Component buildOpacitySelector() {
        this.opacity = new JSlider(0, 100, 50);
        this.opacity.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AlphaCompositesApplication.this.changeComposite();
            }
        });
        JPanel panel = new JPanel();
        panel.add(new JLabel("0%"));
        panel.add(this.opacity);
        panel.add(new JLabel("100%"));
        return panel;
    }

    private Component buildCompositeSelector() {
        this.composites = new JComboBox<String>(new String[]{"CLEAR", "DST", "DST_ATOP", "DST_IN", "DST_OUT", "DST_OVER", "SRC", "SRC_ATOP", "SRC_IN", "SRC_OUT", "SRC_OVER", "XOR"});
        this.composites.setSelectedItem("SRC");
        this.composites.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaCompositesApplication.this.changeComposite();
            }
        });
        return this.composites;
    }

    private void changeComposite() {
        String rule = this.composites.getSelectedItem().toString();
        try {
            Field ruleField = AlphaComposite.class.getDeclaredField(rule);
            AlphaComposite composite = AlphaComposite.getInstance(ruleField.getInt(null), (float)this.opacity.getValue() / 100.0f);
            this.painter.setComposite(composite);
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new AlphaCompositesApplication().setVisible(true);
            }
        });
    }

    private final class CompositePainter
    extends JComponent {
        private AlphaComposite composite = AlphaComposite.getInstance(2, 0.5f);

        private CompositePainter() {
        }

        protected void paintComponent(Graphics g) {
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g2 = image.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.BLUE);
            g.fillRect(4 + this.getWidth() / 4, 4, this.getWidth() / 2, this.getHeight() - 8);
            g.setColor(Color.BLACK);
            g.fillOval(40, 40, this.getWidth() - 80, this.getHeight() - 80);
            g.drawImage(image, 0, 0, null);
        }

        private void setComposite(AlphaComposite composite) {
            this.composite = composite;
            this.repaint();
        }
    }
}

