/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.animation.transitions.Effect;

public final class EffectsManager {
    private static final Map<JComponent, Effect> cachedChangingEffects = new HashMap<JComponent, Effect>();
    private static final Map<JComponent, Effect> cachedAppearingEffects = new HashMap<JComponent, Effect>();
    private static final Map<JComponent, Effect> cachedDisappearingEffects = new HashMap<JComponent, Effect>();

    public static void setEffect(JComponent component, Effect effect, TransitionType transitionType) {
        switch (transitionType) {
            case CHANGING: {
                cachedChangingEffects.put(component, effect);
                break;
            }
            case APPEARING: {
                cachedAppearingEffects.put(component, effect);
                break;
            }
            case DISAPPEARING: {
                cachedDisappearingEffects.put(component, effect);
                break;
            }
            default: {
                throw new InternalError("unknown TransitionType");
            }
        }
    }

    public static Effect getEffect(JComponent component, TransitionType transitionType) {
        switch (transitionType) {
            case CHANGING: {
                return cachedChangingEffects.get(component);
            }
            case APPEARING: {
                return cachedAppearingEffects.get(component);
            }
            case DISAPPEARING: {
                return cachedDisappearingEffects.get(component);
            }
        }
        throw new InternalError("unknown TransitionType");
    }

    private EffectsManager() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransitionType {
        CHANGING,
        APPEARING,
        DISAPPEARING;

    }
}

