/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeyValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyValuesFloat
extends KeyValues<Float> {
    public KeyValuesFloat(float ... values) {
        for (float value : values) {
            this.values.add(Float.valueOf(value));
        }
    }

    @Override
    public Class<?> getType() {
        return Float.TYPE;
    }

    @Override
    public void setValue(Object object, Method method, int i0, int i1, float fraction) {
        float value;
        if (i0 == i1) {
            value = ((Float)this.values.get(i0)).floatValue();
        } else {
            float v0 = ((Float)this.values.get(i0)).floatValue();
            float v1 = ((Float)this.values.get(i1)).floatValue();
            value = v0 + (v1 - v0) * fraction;
        }
        try {
            method.invoke(object, Float.valueOf(value));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }

    @Override
    public void setValue(Object object, Method method, int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVFloat.setValue:" + e);
        }
    }
}

