/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.KeyFrames;
import org.jdesktop.animation.timing.interpolation.KeyValues;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public class FadingDemo
extends JFrame {
    private ImageViewer imageViewer;
    private JButton nextButton;
    private JButton previousButton;
    private HelpGlassPane glass;
    private JTextField titleField;

    public FadingDemo() {
        super("Demonstracja zanikania");
        this.add((Component)this.buildTitle(), "North");
        this.add((Component)this.buildImageViewer(), "Center");
        this.add((Component)this.buildControls(), "South");
        this.pack();
        this.setupGlassPane();
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
    }

    private JComponent buildTitle() {
        this.titleField = new JTextField("Suzhou");
        return this.titleField;
    }

    private void setupGlassPane() {
        this.glass = new HelpGlassPane();
        this.setGlassPane(this.glass);
        this.glass.setVisible(true);
    }

    public static void setTextAndAnimate(final JTextComponent textComponent, final String text) {
        Color c = textComponent.getForeground();
        KeyFrames keyFrames = new KeyFrames(KeyValues.create(new Color(c.getRed(), c.getGreen(), c.getBlue(), 255), new Color(c.getRed(), c.getGreen(), c.getBlue(), 0), new Color(c.getRed(), c.getGreen(), c.getBlue(), 255)));
        PropertySetter setter = new PropertySetter((Object)textComponent, "foreground", keyFrames);
        Animator animator = new Animator(200, setter);
        animator.addTarget(new TimingTargetAdapter(){
            private boolean textSet = false;

            public void timingEvent(float fraction) {
                if (fraction >= 0.5f && !this.textSet) {
                    textComponent.setText(text);
                    this.textSet = true;
                }
            }
        });
        animator.start();
    }

    private JComponent buildControls() {
        JPanel panel = new JPanel(new FlowLayout(3));
        this.previousButton = new JButton("Poprzedni");
        panel.add(this.previousButton);
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FadingDemo.this.imageViewer.previous();
                FadingDemo.setTextAndAnimate(FadingDemo.this.titleField, "Suzhou");
            }
        });
        this.nextButton = new JButton("Nast\u0119pny");
        panel.add(this.nextButton);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FadingDemo.this.imageViewer.next();
                FadingDemo.setTextAndAnimate(FadingDemo.this.titleField, "Szanghaj");
                if (FadingDemo.this.glass.isVisible()) {
                    Animator animator = new Animator(200);
                    animator.addTarget(new PropertySetter((Object)FadingDemo.this.glass, "alpha", Float.valueOf(0.0f)));
                    animator.setAcceleration(0.2f);
                    animator.setDeceleration(0.4f);
                    animator.start();
                }
            }
        });
        return panel;
    }

    private JComponent buildImageViewer() {
        this.imageViewer = new ImageViewer();
        return this.imageViewer;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new FadingDemo().setVisible(true);
            }
        });
    }

    public static class ImageViewer
    extends JComponent {
        private BufferedImage firstImage;
        private BufferedImage secondImage;
        private float alpha = 0.0f;

        private ImageViewer() {
            try {
                this.firstImage = GraphicsUtilities.loadCompatibleImage(this.getClass().getResource("images/suzhou.jpg"));
                this.secondImage = GraphicsUtilities.loadCompatibleImage(this.getClass().getResource("images/shanghai.jpg"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.firstImage.getWidth(), this.firstImage.getHeight());
        }

        public void next() {
            Animator animator = new Animator(1000);
            animator.addTarget(new PropertySetter((Object)this, "alpha", Float.valueOf(1.0f)));
            animator.setAcceleration(0.2f);
            animator.setDeceleration(0.4f);
            animator.start();
        }

        public void previous() {
            Animator animator = new Animator(1000);
            animator.addTarget(new PropertySetter((Object)this, "alpha", Float.valueOf(0.0f)));
            animator.setAcceleration(0.2f);
            animator.setDeceleration(0.4f);
            animator.start();
        }

        public void setAlpha(float alpha) {
            this.alpha = alpha;
            this.repaint();
        }

        public float getAlpha() {
            return this.alpha;
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setComposite(AlphaComposite.SrcOver.derive(1.0f - this.alpha));
            g2.drawImage((Image)this.firstImage, 0, 0, null);
            g2.setComposite(AlphaComposite.SrcOver.derive(this.alpha));
            g2.drawImage((Image)this.secondImage, 0, 0, null);
        }
    }

    public class HelpGlassPane
    extends JComponent {
        private BufferedImage helpImage;
        private float alpha = 1.0f;

        private HelpGlassPane() {
            try {
                this.helpImage = GraphicsUtilities.loadCompatibleImage(this.getClass().getResource("images/help.png"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Animator animator = new Animator(200);
                    animator.addTarget(new PropertySetter((Object)HelpGlassPane.this, "alpha", Float.valueOf(0.0f)));
                    animator.setAcceleration(0.2f);
                    animator.setDeceleration(0.4f);
                    animator.start();
                }
            });
        }

        public void setAlpha(float alpha) {
            this.alpha = alpha;
            if (alpha <= 0.01f) {
                this.setVisible(false);
            }
            this.repaint();
        }

        public float getAlpha() {
            return this.alpha;
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            Point p = FadingDemo.this.nextButton.getLocationOnScreen();
            p.x += FadingDemo.this.nextButton.getWidth() / 2 - 16;
            p.y += FadingDemo.this.nextButton.getHeight() / 2 - this.helpImage.getHeight() + 10;
            SwingUtilities.convertPointFromScreen(p, this);
            g2.setComposite(AlphaComposite.SrcOver.derive(this.alpha));
            g2.drawImage((Image)this.helpImage, p.x, p.y, null);
        }
    }
}

