/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions.effects;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.transitions.ComponentState;
import org.jdesktop.animation.transitions.Effect;

public class CompositeEffect
extends Effect {
    private final List<Effect> effects = new ArrayList<Effect>();

    public CompositeEffect() {
    }

    public CompositeEffect(Effect effect) {
        this.addEffect(effect);
    }

    public void addEffect(Effect effect) {
        this.effects.add(effect);
        if (effect.getRenderComponent()) {
            this.setRenderComponent(true);
        }
        if (this.getStart() == null) {
            this.setStart(effect.getStart());
        }
        if (this.getEnd() == null) {
            this.setEnd(effect.getEnd());
        }
    }

    public void setStart(ComponentState start) {
        for (Effect effect : this.effects) {
            effect.setStart(start);
        }
        super.setStart(start);
    }

    public void init(Animator animator, Effect parentEffect) {
        for (Effect effect : this.effects) {
            effect.init(animator, this);
        }
        super.init(animator, null);
    }

    public void setEnd(ComponentState end) {
        for (Effect effect : this.effects) {
            effect.setEnd(end);
        }
        super.setEnd(end);
    }

    public void setup(Graphics2D g2d) {
        for (int i = 0; i < this.effects.size(); ++i) {
            Effect effect = this.effects.get(i);
            effect.setup(g2d);
            if (this.getRenderComponent() || this.getComponentImage() != null) continue;
            this.setComponentImage(effect.getComponentImage());
        }
        super.setup(g2d);
    }
}

