/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.triggers;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.triggers.FocusTriggerEvent;
import org.jdesktop.animation.timing.triggers.Trigger;
import org.jdesktop.animation.timing.triggers.TriggerEvent;
import org.jdesktop.animation.timing.triggers.TriggerListener;

public class FocusTrigger
extends Trigger {
    public FocusTrigger(TimingController timer, Component source, Trigger.TriggerAction action, FocusTriggerEvent event) {
        this.setupListener(timer, source, action, event);
    }

    public FocusTrigger(TimingController startTimer, Component source, FocusTriggerEvent event, TimingController stopTimer) {
        super(startTimer, source, event, stopTimer);
    }

    public void setupListener(TimingController timer, Object source, Trigger.TriggerAction action, TriggerEvent event) {
        try {
            FocusTriggerListener listener = new FocusTriggerListener(timer, action, (FocusTriggerEvent)event);
            this.setupListener(source, listener, "addFocusListener", FocusListener.class);
        }
        catch (Exception e) {
            System.out.println("Exception creating focus listener for object " + source + ": " + e);
        }
    }

    class FocusTriggerListener
    extends TriggerListener
    implements FocusListener {
        FocusTriggerEvent event;

        protected FocusTriggerListener(TimingController timer, Trigger.TriggerAction action, FocusTriggerEvent event) {
            super(timer, action);
            this.event = event;
        }

        public void focusGained(FocusEvent e) {
            if (this.event == FocusTriggerEvent.FOCUS_IN) {
                this.pullTrigger();
            }
        }

        public void focusLost(FocusEvent e) {
            if (this.event == FocusTriggerEvent.FOCUS_OUT) {
                this.pullTrigger();
            }
        }
    }
}

