/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.awt.Color;
import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeyValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyValuesColor
extends KeyValues<Color> {
    public KeyValuesColor(Color ... values) {
        if (values.length == 1) {
            this.values.add(null);
        }
        for (Color value : values) {
            this.values.add(value);
        }
    }

    @Override
    public Class<?> getType() {
        return Color.class;
    }

    @Override
    public void setValue(Object object, Method method, int i0, int i1, float fraction) {
        Color value;
        Color lowerValue = (Color)this.values.get(i0);
        if (lowerValue == null) {
            lowerValue = (Color)this.startValue;
        }
        if (i0 == i1) {
            value = lowerValue;
        } else {
            Color v0 = lowerValue;
            Color v1 = (Color)this.values.get(i1);
            int red = (int)((double)((float)v0.getRed() + (float)(v1.getRed() - v0.getRed()) * fraction) + 0.5);
            int green = (int)((double)((float)v0.getGreen() + (float)(v1.getGreen() - v0.getGreen()) * fraction) + 0.5);
            int blue = (int)((double)((float)v0.getBlue() + (float)(v1.getBlue() - v0.getBlue()) * fraction) + 0.5);
            int alpha = (int)((double)((float)v0.getAlpha() + (float)(v1.getAlpha() - v0.getAlpha()) * fraction) + 0.5);
            value = new Color(red, green, blue, alpha);
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVColor.setValue:" + e);
        }
    }

    @Override
    public void setValue(Object object, Method method, int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVColor.setValue:" + e);
        }
    }
}

