/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import quicktime.QTSession;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.QTFactory;
import quicktime.std.movies.Movie;
import quicktime.std.movies.media.DataRef;

public class RepaintManagerDemo
extends JFrame {
    private ReflectionPanel reflectionPanel;

    public RepaintManagerDemo() {
        super("Zarz\u0105dca rysowania");
        this.setContentPane(new GradientPanel());
        this.getContentPane().setLayout(new GridBagLayout());
        this.add((Component)this.buildReflectionPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(96, 96, 96, 96), 0, 0));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
    }

    public void dispose() {
        super.dispose();
        QTSession.close();
    }

    private JComponent buildReflectedComponent() {
        try {
            Class.forName("quicktime.QTSession");
        }
        catch (ClassNotFoundException ex) {
            return new DummyPanel();
        }
        try {
            QTSession.open();
            String url = "http://images.apple.com/movies/sony_pictures/spider-man_3/spider-man_3-tlr1_h.480.mov";
            DataRef dRef = new DataRef(url);
            Movie mov = Movie.fromDataRef(dRef, 1);
            MoviePlayer player = new MoviePlayer(mov);
            mov.start();
            JComponent qtPlayer = QTFactory.makeQTJComponent(player).asJComponent();
            return qtPlayer;
        }
        catch (Exception e) {
            return new DummyPanel();
        }
    }

    private JComponent buildReflectionPanel() {
        this.reflectionPanel = new ReflectionPanel();
        this.reflectionPanel.add(this.buildReflectedComponent());
        return this.reflectionPanel;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new RepaintManagerDemo().setVisible(true);
            }
        });
    }

    private static class GradientPanel
    extends JPanel {
        GradientPanel() {
            super(new BorderLayout());
        }

        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setPaint(new GradientPaint(0.0f, (float)this.getHeight() * 0.22f, new Color(2107191), 0.0f, (float)this.getHeight() * 0.7f, Color.BLACK, true));
            Rectangle clip = g.getClipBounds();
            g2.fillRect(clip.x, clip.y, clip.width, clip.height);
            g2.dispose();
        }
    }
}

