/*
 * Decompiled with CFR 0.152.
 */
package org.progx.artemis.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.progx.artemis.graphics.GraphicsUtilities;

class StepLabel
extends JLabel {
    private int step;
    private boolean rebuildIcon;

    public StepLabel() {
        this.setBackground(Color.BLACK);
        this.setForeground(Color.WHITE);
        this.setHorizontalAlignment(0);
        this.setIconTextGap(12);
        this.setFont(new Font("Helvetica", 0, 24));
        this.setStep(1);
        this.setText(" ");
    }

    public void setStep(int step) {
        this.step = step;
        this.rebuildIcon = true;
        this.repaint();
    }

    public int getStep() {
        return this.step;
    }

    protected void paintComponent(Graphics g) {
        if (this.rebuildIcon) {
            FontMetrics fontMetrics = g.getFontMetrics();
            int height = (int)((double)fontMetrics.getHeight() / 1.5 + 2.0);
            BufferedImage image = GraphicsUtilities.createTranslucentCompatibleImage(height, height);
            Graphics2D g2 = image.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            g2.setFont(this.getFont().deriveFont(1, 20.0f));
            fontMetrics = g2.getFontMetrics();
            String s = String.valueOf(this.step);
            int x = (height - fontMetrics.stringWidth(s)) / 2;
            int y = height - fontMetrics.getAscent() / 8;
            Paint paint = g2.getPaint();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, height, Color.GRAY));
            g2.fillOval(0, 0, height, height);
            g2.setPaint(paint);
            g2.setComposite(AlphaComposite.Clear);
            g2.drawString(s, x, y);
            g2.dispose();
            this.setIcon(new ImageIcon(image));
            this.rebuildIcon = false;
        }
        super.paintComponent(g);
    }
}

