/*
 * Decompiled with CFR 0.152.
 */
package org.progx.artemis.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.progx.artemis.Application;
import org.progx.artemis.graphics.GraphicsUtilities;
import org.progx.artemis.graphics.Reflection;
import org.progx.artemis.ui.MainFrame;

class SizeStepPanel
extends JPanel {
    private BufferedImage small;
    private BufferedImage medium;
    private BufferedImage large;
    private boolean isLoaded;
    private int smallHeight;
    private int mediumHeight;
    private int largeHeight;
    private Rectangle largeImageBounds;
    private Rectangle mediumImageBounds;
    private Rectangle smallImageBounds;

    public SizeStepPanel() {
        this.setBackground(Color.BLACK);
        this.setOpaque(false);
        this.createThumbnails();
        this.addMouseMotionListener(new CursorChanger());
        this.addMouseListener(new SizeSelector());
    }

    private void createThumbnails() {
        Thread loader = new Thread(new Runnable(){

            public void run() {
                final MainFrame mainFrame = Application.getMainFrame();
                BufferedImage image = mainFrame.getImage();
                SizeStepPanel.this.small = GraphicsUtilities.createThumbnail(image, 90);
                SizeStepPanel.this.smallHeight = SizeStepPanel.this.small.getHeight();
                SizeStepPanel.this.small = Reflection.createReflection(SizeStepPanel.this.small);
                SizeStepPanel.this.medium = GraphicsUtilities.createThumbnail(image, 160);
                SizeStepPanel.this.mediumHeight = SizeStepPanel.this.medium.getHeight();
                SizeStepPanel.this.medium = Reflection.createReflection(SizeStepPanel.this.medium);
                SizeStepPanel.this.large = GraphicsUtilities.createThumbnail(image, 240);
                SizeStepPanel.this.largeHeight = SizeStepPanel.this.large.getHeight();
                SizeStepPanel.this.large = Reflection.createReflection(SizeStepPanel.this.large);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        mainFrame.hideWaitGlassPane();
                    }
                });
                SizeStepPanel.this.isLoaded = true;
                SizeStepPanel.this.repaint();
            }
        });
        loader.start();
    }

    public void dispose() {
        if (this.large != null) {
            this.large.flush();
            this.large = null;
        }
        if (this.medium != null) {
            this.medium.flush();
            this.medium = null;
        }
        if (this.small != null) {
            this.small.flush();
            this.small = null;
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isLoaded) {
            return;
        }
        int totalWidth = 48;
        int x = (this.getWidth() - (totalWidth += this.large.getWidth() + this.medium.getWidth() + this.small.getWidth())) / 2;
        int y = (this.getHeight() - this.large.getHeight()) / 2;
        g.drawImage(this.large, x, y += 42, null);
        if (this.largeImageBounds == null) {
            this.largeImageBounds = new Rectangle(x, y, this.large.getWidth(), this.largeHeight);
        }
        g.drawImage(this.medium, x += this.large.getWidth() + 24, y += this.largeHeight - this.mediumHeight, null);
        if (this.mediumImageBounds == null) {
            this.mediumImageBounds = new Rectangle(x, y, this.medium.getWidth(), this.mediumHeight);
        }
        g.drawImage(this.small, x += this.medium.getWidth() + 24, y += this.mediumHeight - this.smallHeight, null);
        if (this.smallImageBounds == null) {
            this.smallImageBounds = new Rectangle(x, y, this.small.getWidth(), this.smallHeight);
        }
    }

    private static void saveImage(final BufferedImage image, final File file) {
        Thread writer = new Thread(new Runnable(){

            public void run() {
                try {
                    ImageIO.write((RenderedImage)image, "JPEG", file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Application.getMainFrame().showDoneStep();
                    }
                });
            }
        });
        writer.start();
    }

    private class CursorChanger
    extends MouseAdapter {
        private CursorChanger() {
        }

        public void mouseMoved(MouseEvent e) {
            Point point = e.getPoint();
            if (SizeStepPanel.this.largeImageBounds != null && SizeStepPanel.this.largeImageBounds.contains(point) || SizeStepPanel.this.mediumImageBounds != null && SizeStepPanel.this.mediumImageBounds.contains(point) || SizeStepPanel.this.smallImageBounds != null && SizeStepPanel.this.smallImageBounds.contains(point)) {
                SizeStepPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (!SizeStepPanel.this.getCursor().equals(Cursor.getDefaultCursor())) {
                SizeStepPanel.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private class SizeSelector
    extends MouseAdapter {
        private SizeSelector() {
        }

        public void mouseClicked(MouseEvent e) {
            Point point = e.getPoint();
            for (final Rectangle r : new Rectangle[]{SizeStepPanel.this.largeImageBounds, SizeStepPanel.this.mediumImageBounds, SizeStepPanel.this.smallImageBounds}) {
                if (r == null || !r.contains(point)) continue;
                Application.getMainFrame().showWaitGlassPane();
                Thread sizer = new Thread(new Runnable(){

                    public void run() {
                        int width = r == SizeStepPanel.this.largeImageBounds ? 1024 : (r == SizeStepPanel.this.mediumImageBounds ? 800 : 640);
                        final BufferedImage toSave = GraphicsUtilities.createThumbnail(Application.getMainFrame().getImage(), width);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JFileChooser chooser = new JFileChooser();
                                chooser.setSelectedFile(new File(MessageFormat.format(Application.getResourceBundle().getString("file.save.prefix"), Application.getMainFrame().getFileName())));
                                SizeStepPanel.this.dispose();
                                if (chooser.showSaveDialog(Application.getMainFrame()) == 0) {
                                    File selectedFile = chooser.getSelectedFile();
                                    if (!selectedFile.getPath().toLowerCase().endsWith(".jpg")) {
                                        selectedFile = new File(selectedFile.getPath() + ".jpg");
                                    }
                                    SizeStepPanel.saveImage(toSave, selectedFile);
                                } else {
                                    Application.getMainFrame().showDragAndDropStep();
                                }
                            }
                        });
                    }
                });
                sizer.start();
            }
        }
    }
}

