/*
 * Decompiled with CFR 0.152.
 */
package org.progx.artemis.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.progx.artemis.Application;
import org.progx.artemis.graphics.GraphicsUtilities;
import org.progx.artemis.image.ColorTintFilter;
import org.progx.artemis.image.GaussianBlurFilter;
import org.progx.artemis.ui.MainFrame;

public class ProgressGlassPane
extends JComponent {
    private static final int BAR_WIDTH = 200;
    private static final int BAR_HEIGHT = 10;
    private static final Color TEXT_COLOR = new Color(0xFFFFFF);
    private static final float[] GRADIENT_FRACTIONS = new float[]{0.0f, 0.499f, 0.5f, 1.0f};
    private static final Color[] GRADIENT_COLORS = new Color[]{Color.GRAY, Color.DARK_GRAY, Color.BLACK, Color.GRAY};
    private static final Color GRADIENT_COLOR2 = Color.WHITE;
    private static final Color GRADIENT_COLOR1 = Color.GRAY;
    private String message = Application.getResourceBundle().getString("wait.message");
    private int progress = 0;
    private BufferedImage backDrop = null;

    public ProgressGlassPane() {
        this.setBackground(Color.WHITE);
        this.setFont(new Font("Helvetica", 1, 16));
        this.setOpaque(true);
    }

    public int getProgress() {
        return this.progress;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            MainFrame mainFrame = Application.getMainFrame();
            this.backDrop = GraphicsUtilities.createCompatibleImage(mainFrame.getRootPane().getWidth(), mainFrame.getRootPane().getHeight());
            Graphics2D g2 = this.backDrop.createGraphics();
            mainFrame.getRootPane().paint(g2);
            g2.dispose();
            this.backDrop = GraphicsUtilities.createThumbnail(this.backDrop, mainFrame.getRootPane().getWidth() / 2);
            this.backDrop = new ColorTintFilter(Color.BLACK, 0.1f).filter(this.backDrop, null);
            this.backDrop = new GaussianBlurFilter(12).filter(this.backDrop, null);
        } else {
            if (this.backDrop != null) {
                this.backDrop.flush();
            }
            this.backDrop = null;
        }
        super.setVisible(visible);
    }

    public void setProgress(int progress) {
        int oldProgress = this.progress;
        this.progress = progress;
        if (progress > oldProgress) {
            FontMetrics metrics = this.getGraphics().getFontMetrics(this.getFont());
            int w = (int)(200.0f * ((float)oldProgress / 100.0f));
            int x = w + (this.getWidth() - 200) / 2;
            int y = (this.getHeight() - 10) / 2;
            w = (int)(200.0f * ((float)progress / 100.0f)) - w;
            int h = 10;
            this.repaint(x, y += metrics.getDescent() / 2 + 2, w, h);
        } else {
            FontMetrics metrics = this.getGraphics().getFontMetrics(this.getFont());
            int w = (int)(200.0f * ((float)oldProgress / 100.0f));
            int x = w + (this.getWidth() - 200) / 2;
            int y = (this.getHeight() - 10) / 2;
            w = (int)(200.0f * ((float)progress / 100.0f)) + w;
            int h = 10;
            this.repaint(x, y += metrics.getDescent() / 2 + 2, w, h);
        }
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        MainFrame mainFrame = Application.getMainFrame();
        int width = mainFrame.getRootPane().getWidth();
        int height = mainFrame.getRootPane().getHeight();
        g2.drawImage(this.backDrop, 0, 0, width, height, null);
        AlphaComposite alpha = AlphaComposite.SrcOver.derive(0.75f);
        Composite composite = g2.getComposite();
        FontMetrics metrics = g.getFontMetrics();
        int x = (this.getWidth() - 200) / 2;
        int y = (this.getHeight() - 10 - metrics.getDescent()) / 2;
        g2.setComposite(alpha);
        g2.setColor(Color.BLACK);
        g2.fillRoundRect(x - 15, y - metrics.getAscent() - 7, 230, 32 + metrics.getAscent(), 20, 20);
        g2.setComposite(composite);
        g2.setColor(TEXT_COLOR);
        g2.drawString(this.message, x, y);
        int w = (int)(200.0f * ((float)this.progress / 100.0f));
        int h = 10;
        Paint paint = g2.getPaint();
        g2.setComposite(alpha);
        Paint gradient = new GradientPaint(x, y += metrics.getDescent() + 2, GRADIENT_COLOR1, x, y + h, GRADIENT_COLOR2);
        g2.setPaint(gradient);
        g2.fillRect(x, y, 200, 10);
        gradient = new LinearGradientPaint(x, y, x, y + h, GRADIENT_FRACTIONS, GRADIENT_COLORS);
        g2.setPaint(gradient);
        g2.fillRect(x, y, w, h);
        g2.setPaint(paint);
        g2.setColor(Color.DARK_GRAY);
        g2.drawRect(x, y, 200, 10);
        g2.setComposite(composite);
    }
}

