/*
 * Decompiled with CFR 0.152.
 */
package org.progx.artemis.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.TransferHandler;
import org.progx.artemis.Application;
import org.progx.artemis.graphics.GraphicsUtilities;

class ImageTransferHandler
extends TransferHandler {
    ImageTransferHandler() {
    }

    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean copySupported;
        if (!support.isDrop()) {
            return false;
        }
        if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        boolean bl = copySupported = (1 & support.getSourceDropActions()) == 1;
        if (copySupported) {
            support.setDropAction(1);
            return true;
        }
        return false;
    }

    public boolean importData(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        Transferable t = support.getTransferable();
        try {
            Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
            final File file = (File)((List)data).get(0);
            Thread loader = new Thread(new Runnable(){

                public void run() {
                    Application.getMainFrame().showWaitGlassPane();
                    try {
                        BufferedImage image = GraphicsUtilities.loadCompatibleImage(file.toURI().toURL());
                        Application.getMainFrame().setImage(image, file.getName());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Application.getMainFrame().hideWaitGlassPane();
                    }
                }
            });
            loader.start();
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

