/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.transitions.AnimationLayer;
import org.jdesktop.animation.transitions.AnimationManager;
import org.jdesktop.animation.transitions.TransitionTarget;

public class ScreenTransition {
    private AnimationManager animationManager;
    private AnimationLayer animationLayer;
    private JComponent containerLayer;
    private BufferedImage transitionImage;
    private TransitionTarget transitionTarget;
    private Component savedGlassPane;
    private Animator animator = null;
    private TimingTarget transitionTimingTarget = new TimingTargetAdapter(){

        public void begin() {
            ScreenTransition.this.animationManager.reset();
            ScreenTransition.this.animationManager.setupStart();
            int cw = ScreenTransition.this.containerLayer.getWidth();
            int ch = ScreenTransition.this.containerLayer.getHeight();
            if (ScreenTransition.this.transitionImage == null || ScreenTransition.this.transitionImage.getWidth() != cw || ScreenTransition.this.transitionImage.getHeight() != ch) {
                ScreenTransition.this.transitionImage = (BufferedImage)ScreenTransition.this.containerLayer.createImage(cw, ch);
            }
            ScreenTransition.this.animationLayer.setupBackground(ScreenTransition.this.containerLayer);
            ScreenTransition.this.savedGlassPane = ScreenTransition.this.containerLayer.getRootPane().getGlassPane();
            ScreenTransition.this.containerLayer.getRootPane().setGlassPane(ScreenTransition.this.animationLayer);
            ScreenTransition.this.containerLayer.getRootPane().getGlassPane().setVisible(true);
            ScreenTransition.this.transitionTarget.setupNextScreen();
            ScreenTransition.this.containerLayer.validate();
            ScreenTransition.this.animationManager.setupEnd();
            ScreenTransition.this.animationManager.init(ScreenTransition.this.animator);
            ScreenTransition.this.containerLayer.setVisible(false);
            this.timingEvent(0.0f);
        }

        public void timingEvent(float elapsedFraction) {
            Graphics2D gImg = (Graphics2D)ScreenTransition.this.transitionImage.getGraphics();
            ScreenTransition.this.animationManager.paint(gImg);
            gImg.dispose();
            ScreenTransition.this.animationLayer.repaint();
        }

        public void end() {
            ScreenTransition.this.containerLayer.getRootPane().setGlassPane(ScreenTransition.this.savedGlassPane);
            ScreenTransition.this.containerLayer.getRootPane().getGlassPane().setVisible(false);
            ScreenTransition.this.animationLayer.setVisible(false);
            ScreenTransition.this.containerLayer.setVisible(true);
            ScreenTransition.this.containerLayer.repaint();
        }
    };

    private ScreenTransition(JComponent transitionComponent, TransitionTarget transitionTarget) {
        this.containerLayer = transitionComponent;
        this.transitionTarget = transitionTarget;
        this.animationManager = new AnimationManager(transitionComponent);
        this.animationLayer = new AnimationLayer(this);
        this.animationLayer.setVisible(false);
    }

    public ScreenTransition(JComponent transitionComponent, TransitionTarget transitionTarget, int duration) {
        this(transitionComponent, transitionTarget);
        this.setAnimator(new Animator(duration, this.transitionTimingTarget));
    }

    public ScreenTransition(JComponent transitionComponent, TransitionTarget transitionTarget, Animator animator) {
        this(transitionComponent, transitionTarget);
        this.setAnimator(animator);
    }

    public Animator getAnimator() {
        return this.animator;
    }

    public void setAnimator(Animator animator) {
        if (animator == null) {
            throw new IllegalArgumentException("Animator must be non-null");
        }
        if (animator.isRunning()) {
            throw new IllegalStateException("Cannot perform this operation while animator is running");
        }
        this.animator = animator;
        animator.addTarget(this.transitionTimingTarget);
    }

    Image getTransitionImage() {
        return this.transitionImage;
    }

    public void start() {
        if (this.animator.isRunning()) {
            this.animator.stop();
        }
        this.animator.start();
    }
}

