/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.transitions.AnimationState;
import org.jdesktop.animation.transitions.ComponentState;

class AnimationManager {
    private Map<JComponent, AnimationState> componentAnimationStates = new HashMap<JComponent, AnimationState>();
    private ArrayList<JComponent> changingComponents = new ArrayList();
    JComponent container = null;
    private BufferedImage transitionImageBG = null;

    AnimationManager(JComponent container) {
        this.container = container;
    }

    private AnimationState getExistingAnimationState(Component component) {
        return this.componentAnimationStates.get(component);
    }

    void reset() {
        this.componentAnimationStates.clear();
        this.changingComponents.clear();
    }

    void init(Animator animator) {
        int cw = this.container.getWidth();
        int ch = this.container.getHeight();
        if (this.transitionImageBG == null || this.transitionImageBG.getWidth() != cw || this.transitionImageBG.getHeight() != ch) {
            this.transitionImageBG = (BufferedImage)this.container.createImage(cw, ch);
        }
        ArrayList<Component> componentsToRemove = new ArrayList<Component>();
        for (AnimationState state : this.componentAnimationStates.values()) {
            Rectangle componentBounds;
            ComponentState start = state.getStart();
            ComponentState end = state.getEnd();
            Rectangle bounds = null;
            if (start != null) {
                bounds = new Rectangle(start.getX(), start.getY(), start.getWidth(), start.getHeight());
            }
            if (end != null) {
                Rectangle boundsEnd = new Rectangle(end.getX(), end.getY(), end.getWidth(), end.getHeight());
                bounds = bounds == null ? boundsEnd : bounds.union(boundsEnd);
            }
            if (bounds.intersects(componentBounds = this.container.getBounds())) continue;
            componentsToRemove.add(state.getComponent());
        }
        for (Component component : componentsToRemove) {
            this.componentAnimationStates.remove(component);
            this.changingComponents.remove(component);
        }
        for (JComponent child : this.changingComponents) {
            child.setVisible(false);
        }
        Graphics gImg = this.transitionImageBG.getGraphics();
        gImg.clearRect(0, 0, cw, ch);
        ComponentState.paintHierarchySingleBuffered(this.container, gImg);
        gImg.dispose();
        for (JComponent child : this.changingComponents) {
            child.setVisible(true);
        }
        for (AnimationState state : this.componentAnimationStates.values()) {
            state.init(animator);
        }
    }

    void setupStart() {
        for (Component child : this.container.getComponents()) {
            if (!child.isVisible() || !(child instanceof JComponent)) continue;
            this.addStart((JComponent)child);
        }
    }

    void setupEnd() {
        for (Component child : this.container.getComponents()) {
            if (!child.isVisible() || !(child instanceof JComponent)) continue;
            ComponentState end = new ComponentState((JComponent)child);
            AnimationState animState = this.getExistingAnimationState(child);
            if (animState != null) {
                ComponentState start = animState.getStart();
                if (start != null && start.equals(end)) {
                    this.componentAnimationStates.remove(child);
                    continue;
                }
                this.changingComponents.add((JComponent)child);
                animState.setEnd(end);
                continue;
            }
            this.changingComponents.add((JComponent)child);
            animState = new AnimationState(end, false);
            this.componentAnimationStates.put((JComponent)child, animState);
        }
    }

    void addStart(JComponent component) {
        AnimationState existingAnimState = this.getExistingAnimationState(component);
        if (existingAnimState != null) {
            existingAnimState.setStart(new ComponentState(component));
        } else {
            AnimationState animState = new AnimationState(component, true);
            this.componentAnimationStates.put(component, animState);
        }
    }

    void addEnd(JComponent component) {
        AnimationState existingAnimState = this.getExistingAnimationState(component);
        if (existingAnimState != null) {
            existingAnimState.setEnd(new ComponentState(component));
        } else {
            AnimationState animState = new AnimationState(component, false);
            this.componentAnimationStates.put(component, animState);
        }
    }

    void paint(Graphics g) {
        g.drawImage(this.transitionImageBG, 0, 0, null);
        for (AnimationState state : this.componentAnimationStates.values()) {
            state.paint(g);
        }
    }
}

