#!/usr/bin/env python3

# Copyright 2014 Brett Slatkin, Pearson Education Inc.
#
# Udostępniono na licencji Apache w wersji 2.0 ("Licencja").
# Tego pliku można używać jedynie zgodnie z warunkami Licencji.
# Treść Licencji znajdziesz na stronie:
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# O ile obowiązujące prawo nie stanowi inaczej lub czegoś innego nie
# uzgodniono w formie pisemnej, oprogramowanie objęte Licencją jest
# dostarczane w stanie, w jakim jest (wersja "AS IS"), BEZ JAKIEJKOLWIEK
# GWARANCJI, ani wyrażonej otwarcie, ani domyślnej. Dokładne zasady
# i warunki Licencji znajdziesz w jej treści.

# Przygotowania mające na celu odtworzenie środowiska użytego w książce.
import logging
from pprint import pprint
from sys import stdout as STDOUT


# Przykład 1.
print('foo bar')


# Przykład 2.
print('%s' % 'foo bar')


# Przykład 3.
print(5)
print('5')


# Przykład 4.
a = '\x07'
print(repr(a))


# Przykład 5.
b = eval(repr(a))
assert a == b


# Przykład 6.
print(repr(5))
print(repr('5'))


# Przykład 7.
print('%r' % 5)
print('%r' % '5')


# Przykład 8.
class OpaqueClass(object):
    def __init__(self, x, y):
        self.x = x
        self.y = y

obj = OpaqueClass(1, 2)
print(obj)


# Przykład 9.
class BetterClass(object):
    def __init__(self, x, y):
        self.x = 1
        self.y = 2
    def __repr__(self):
        return 'BetterClass(%d, %d)' % (self.x, self.y)


# Przykład 10.
obj = BetterClass(1, 2)
print(obj)


# Przykład 11.
obj = OpaqueClass(4, 5)
print(obj.__dict__)
