<?php

// W skrypcie znajdują się definicje wymagane przez różne formularze.
// Skrypt jest tworzony w rozdziale 10.
// Obsługa pola TEXTAREA jest dodawana w rozdziale 11.

// Funkcja generuje pola INPUT i SELECT.
// Przyjmuje pięć argumentów:
// - Nazwę elementu.
// - Typ elementu (text, password, select).
// - Tablicę błędów.
// - Tablicę, w której znajdują się wartości (POST, SESSION).
// - Dodatkowe atrybuty HTML (autocomplete="off", readonly="readonly")
function create_form_input($name, $type, $errors, $values = 'POST', $extras = '') {
	
	// Załóż, że żadna wartość nie istnieje:
	$value = false;
	
	// Pobierz wartość, jeżeli istnieje:
	if ($values == 'SESSION') {
		
		if (isset($_SESSION[$name])) $value = $_SESSION[$name];
		
	} elseif ($values == 'POST') {
		
		if (isset($_POST[$name])) $value = $_POST[$name];
		// Jeśli mechanizm Magic Quotes jest włączony, usuń ukośniki:
		if ($value && get_magic_quotes_gpc()) $value = stripslashes($value);

	}

	// Conditional to determine what kind of element to create:
	if ( ($type == 'text') || ($type == 'password') ) { // Create text or password inputs.
		
		// Utwórz pole wejściowe:
		echo '<input type="' . $type . '" name="' . $name . '" id="' . $name . '"';
		
		// Do pola dodaj wartość:
		if ($value) echo ' value="' . htmlspecialchars($value) . '"';
		
		// Uzupełnij o dodatki:
		if (!empty($extras)) echo " $extras";

		// Sprawdź, czy wystapił błąd:
		if (array_key_exists($name, $errors)) {
			echo 'class="error" /> <span class="error">' . $errors[$name] . '</span>';
		} else {
			echo ' />';		
		}
		
	} elseif ($type == 'select') { // Pole select.
		
		if (($name == 'state') || ($name == 'cc_state')) { // Lista województw.
			
		$data = array('DS' => 'dolnośląskie', 'KP' => 'kujawsko-pomorskie', 'LB' => 'lubelskie', 'LS' => 'lubuskie', 'LO' => 'łódzkie', 'MP' => 'małopolskie', 'MA' => 'mazowieckie', 'OP' => 'opolskie', 'PK' => 'podkarpackie', 'PD' => 'podlaskie', 'PM' => 'pomorskie', 'SL' => 'śląskie', 'SW' => 'świętokrzyskie', 'WM' => 'warmińsko-mazurskie', 'WP' => 'wielkopolskie', 'ZP' => 'zachodniopomorskie');
		} elseif ($name == 'cc_exp_month') { // Lista miesięcy.

      $data = array(1 => 'styczeń', 'luty', 'marzec', 'kwiecień', 'maj', 'czerwiec', 'lipiec', 'sierpień', 'wrzesień', 'październik', 'listopad', 'grudzień');			
		} elseif ($name == 'cc_exp_year') { // Lista lat.
						
			$data = array();
			$start = date('Y'); // Rozpocznij w bieżącym roku.
			for ($i = $start; $i <= $start + 5; $i++) { // Dodaj jeszcze pięć lat.
				$data[$i] = $i;
			}
			
		} // Koniec instrukcji IF-ELSEIF $name.
		
		// Początek znacznika:
		echo '<select name="' . $name  . '"';
	
		// Jeżeli trzeba, dodaj klasę error:
		if (array_key_exists($name, $errors)) echo ' class="error"';
		
		// Znacznik zamykający:
		echo '>';		
	
		// Utwórz wszystkie opcje:
		foreach ($data as $k => $v) {
			echo "<option value=\"$k\"";
			
			// Wybierz wartość:
			if ($value == $k) echo ' selected="selected"';
			
			echo ">$v</option>\n";
			
		} // Koniec pętli FOREACH.
	
		// Zakończ znacznik:
		echo '</select>';
		
		// Dodaj informację o błędzie, jeżeli jakakolwiek istnieje:
		if (array_key_exists($name, $errors)) {
			echo '<br /><span class="error">' . $errors[$name] . '</span>';
		}
		
	} elseif ($type == 'textarea') { // Utwórz pole TEXTAREA.

		// Najpierw wyświetl komunikat o błędzie: 
		if (array_key_exists($name, $errors)) echo ' <span class="error">' . $errors[$name] . '</span><br />';

		// Początek znacznika pola tekstowego:
		echo '<textarea name="' . $name . '" id="' . $name . '" rows="5" cols="75"';

		// Jeśli wystąpił błąd, dodaj klasę error:
		if (array_key_exists($name, $errors)) {
			echo ' class="error">';
		} else {
			echo '>';		
		}

		// Do pola dodaj wartość:
		if ($value) echo $value;

		// Zakończ definicję pola:
		echo '</textarea>';

	} // Koniec głównej instrukcji IF-ELSEIF.

} // Koniec funkcji create_form_input().

// Pomiń zamykający znacznik PHP, by uniknąć błędów 'headers already sent'!
