<?php

// Skrypt wysyła wiadomość w formacie HTML.
// Skrypt jest tworzony w rozdziale 10.

// Utwórz komunikat w dwóch formatach:
$body_plain = "Dziękujemy za złożenie zamówienia. Numer zamówienia: {$_SESSION['order_id']}. Wszystkie zamówienia są obsługiwane w następny dzień roboczy. W przypadku wystąpienia opóźnień, zostaniesz powiadomiony.\n\n";

$body_html = '<html><head><style type="text/css" media="all">
	body {font-family:Tahoma, Geneva, sans-serif; font-size:100%; line-height:.875em; color:#70635b;}
</style></head><body>
<p>Dziękujemy za złożenie zamówienia. Numer zamówienia: ' . $_SESSION['order_id'] . '. Wszystkie zamówienia są obsługiwane w następny dzień roboczy. W przypadku wystąpienia opóźnień, zostaniesz powiadomiony.</p>
<table border="0" cellspacing="8" cellpadding="6">
	<tr>
		<th align="center">Item</th>
		<th align="center">Quantity</th>
		<th align="right">Price</th>
		<th align="right">Subtotal</th>
	</tr>';

// Pobierz zawartość koszyka na potrzeby e-maila potwierdzającego zamówienie:
$r = mysqli_query($dbc, "CALL get_order_contents({$_SESSION['order_id']})");

// Pobierz wszystkie pozycje:
while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
	
	// Dodaj do wersji tekstowej:
	$body_plain .= "{$row['category']}::{$row['name']} ({$row['quantity']}) @ \${$row['price_per']} each: $" . $row['subtotal'] . "\n";
	
	// Dodaj do HTML-a:
	$body_html .= '<tr><td>' . $row['category'] . '::' . $row['name'] . '</td>
		<td align="center">' . $row['quantity'] . '</td>
		<td align="right">$' . $row['price_per'] . '</td>
		<td align="right">$' . $row['subtotal'] . '</td>
	</tr>
	';
	
	// Wartości po wykonaniu pętli:
	$shipping = $row['shipping'];
	$total = $row['total'];

} // Zakończ pętlę WHILE. 

// Wyczyść wynik procedury składowanej:
mysqli_next_result($dbc);

// Dodaj informację o koszcie przesyłki:
$body_html .= '<tr>
	<td colspan="2"> </td><th align="right">Przesyłka i obsługa</th>
	<td align="right">' . $shipping . ' zł</td>
</tr>
';
$body_plain .= "Przesyłka i obsługa zamówienia: \$$shipping\n";

// Dodaj całkowitą wartość:
$body_plain .= "Całkowita wartość: $total zł\n";
$body_html .= '<tr>
	<td colspan="2"> </td><th align="right">Całkowita wartość</th>
	<td align="right">' . $total . ' zł</td>
</tr>
';

// Zakończ sekcję body HTML-a:
$body_html .= '</table></body></html>';

// Dla frameworku Zend:
set_include_path('./library/');

// Dołącz definicję klas:
include ('Zend/Mail.php');  

// Utwórz nowy e-mail:
$mail = new Zend_Mail(); 
$mail->setFrom('admin@example.com');
$mail->addTo($_SESSION['email']);
$mail->setSubject("Order #{$_SESSION['order_id']} at the Coffee Site");
$mail->setBodyText($body_plain);
$mail->setBodyHtml($body_html); 
$mail->send();  
