<?php

// Pełny, bardziej formalny sposób komentowania został zastosowany tylko w tym pliku, ale może (a nawet powinien) być stosowany w każdym:
/* 	*
	* Nazwa: config.inc.php
	* Utworzony przez: Larry E. Ullman z firmy DMC Insights, Inc. 
	* Kontakt: Larry@DMCInsights.com, http://www.dmcinsights.com
	* Ostatnio zmodyfikowany: 28-07-2010
	*
	* Plik konfiguracyjny odpowiada za następujące elementy:
	* - Przechowuje lokalizację witryny.
	* - Przechowuje adresy URL i URI jako stałe.
	* - Rozpoczyna sesję.
	* - Definiuje sposób obsługi błędów.
	* - Definiuje funkcję przekierowującą.
	*
	* Praca nad tym skryptem rozpoczyna się w rozdziale 3.
*/

// ********************************** //
// ************ USTAWIENIA ************ //

// Czy strona jest online?
$live = false;

// Adres e-mail, na który są wysyłane komunikaty o błędach:
$contact_email = 'you@example.com';

// ************ USTAWIENIA ************ //
// ********************************** //

// ********************************** //
// ************ STAŁE *********** //

// Lokalizacja plików i URL witryny:
define ('BASE_URI', '/katalog/podkatalog/sklepy/cw2/');
define ('BASE_URL', 'localhost:8888/');
define ('MYSQL', BASE_URI . 'mysql.inc.php');

// ************ STAŁE *********** //
// ********************************** //

// ****************************************** //
// ************ OBSŁUGA BŁĘDÓW ************ //

// Funkcja obsługi błędów.
// Przyjmuje pięć argumentów: numer błędu, komunikat (tekst), nazwę pliku, w którym wystąpił błąd (tekst),
// numer wiersza, w którym wystąpił błąd oraz zmienne istniejące w chwili wystąpienia błędu (tablica).
// Zwraca true.
function my_error_handler ($e_number, $e_message, $e_file, $e_line, $e_vars) {

	// Dwie wymagane zmienne:
	global $live, $contact_email;
	
	// Złóż komunikat o błędzie:
	$message = "W skrypcie '$e_file' wystąpił błąd w wierszu $e_line:\n$e_message\n";
	
	// Dodaj szczegółowe informacje:
	$message .= "<pre>" .print_r(debug_backtrace(), 1) . "</pre>\n";
	
	// Lub dołącz zmienną $e_vars do komunikatu:
	//	$message .= "<pre>" . print_r ($e_vars, 1) . "</pre>\n";

	if (!$live) { // Wyświetl komunikat w przeglądarce.
		
		echo '<div class="error">' . nl2br($message) . '</div>';

	} else { // Wytwarzanie (wyświetl komunikat).

		// Wyślij komunikat na adres e-mailowy:
		error_log ($message, 1, $contact_email, 'From:admin@example.com');
		
		// Jeśli błąd jest tylko powiadomieniem, wyświetl w przeglądarce:
		if ($e_number != E_NOTICE) {
			echo '<div class="error">Wystąpił błąd systemu. Przepraszamy za niedogodności.</div>';
		}

	} // Koniec instrukcji IF-ELSE $live.
	
	return true; // Zwróć true, aby PHP nie obsługiwało błędu.

} // Koniec funkcji my_error_handler().

// Użyj funkcji obsługi błędów:
set_error_handler ('my_error_handler');

// ************ OBSŁUGA BŁĘDÓW ************ //
// ****************************************** //

// Pomiń zamykający znacznik PHP, by uniknąć błędów 'headers already sent'!
