<?php

// Skrypt odpowiada za ostatnią stronę procesu zamawiania. 
// Praca nad skryptem rozpoczyna się w rozdziale 10.

// Dołącz plik konfiguracyjny przed kodem PHP:
require ('./includes/config.inc.php');

// Rozpocznij sesję:
session_start();

// Identyfikator koszyka na zakupy jest taki sam jak identyfikator sesji:
$uid = session_id();

// Sprawdź czy identyfikator jest poprawny:
if (!isset($_SESSION['customer_id'])) { // Przekieruj użytkownika.
	$location = 'https://' . BASE_URL . 'checkout.php';
	header("Location: $location");
	exit();
} elseif (!isset($_SESSION['response_code']) || ($_SESSION['response_code'] != 1)) {
	$location = 'https://' . BASE_URL . 'billing.php';
	header("Location: $location");
	exit();
}

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Wyczyść zawartość koszyka:
$r = mysqli_query($dbc, "CALL clear_cart('$uid')");

// Wyślij e-mail:
include('./includes/email_receipt.php');

// Dołącz plik nagłówka:
$page_title = 'Kawy świata - zamawianie - Twoje zamówienie zostało sfinalizowane';
include ('./includes/checkout_header.html');

// Dołącz plik widoku:
include('./views/final.html');

// Wyczyść tablicę sesji:
$_SESSION = array(); // Usuń zmienne.
session_destroy(); // Usuń sesję.

// Dołącz plik stopki:
include ('./includes/footer.html');
?>
