<?php

// Skrypt obsługuje drugi krok procesu zamawiania.
// Jest odpowiedzialny za przyjęcie i sprawdzenie informacji.
// Praca nad skryptem rozpoczyna się w rozdziale 10.

// Dołącz plik konfiguracyjny przed kodem PHP:
require ('./includes/config.inc.php');

// Rozpocznij sesję:
session_start();

// Identyfikator sesji jest identyfikatorem koszyka użytkownika:
$uid = session_id();

// Sprawdź, czy identyfikator jest prawidłowy:
if (!isset($_SESSION['customer_id'])) { // Przekieruj użytkownika.
	$location = 'https://' . BASE_URL . 'checkout.php';
	header("Location: $location");
	exit();
}

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Sprawdź formularz...

// Tablica błędów:
$billing_errors = array();

// Sprawdź, czy formularz został przesłany:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

	if (get_magic_quotes_gpc()) {
		$_POST['cc_first_name'] = stripslashes($_POST['cc_first_name']);
		// Zrób to samo dla wszystkich zmiennych, które tego wymagają.
	}

	// Sprawdź pole imienia:
	if (preg_match ('/^[A-ZąćęłńóśżźĄĆĘŁŃÓŚŻŹ \'.-]{2,20}$/i', $_POST['cc_first_name'])) {
		$cc_first_name = $_POST['cc_first_name'];
	} else {
		$billing_errors['cc_first_name'] = 'Wpisz imię!';
	}
	
	// Sprawdź pole nazwiska:
	if (preg_match ('/^[A-ZąćęłńóśżźĄĆĘŁŃÓŚŻŹ \'.-]{2,40}$/i', $_POST['cc_last_name'])) {
		$cc_last_name  = $_POST['cc_last_name'];
	} else {
		$billing_errors['cc_last_name'] = 'Wpisz nazwisko!';
	}
	
	// Sprawdź poprawność numeru karty kredytowej...
	// Usuń spacje i łączniki:
	$cc_number = str_replace(array(' ', '-'), '', $_POST['cc_number']);
	
	// Sprawdź numer karty w zależności od jej typu:
	if (!preg_match ('/^4[0-9]{12}(?:[0-9]{3})?$/', $cc_number) // Visa
	&& !preg_match ('/^5[1-5][0-9]{14}$/', $cc_number) // MasterCard
	&& !preg_match ('/^3[47][0-9]{13}$/', $cc_number) // American Express
	&& !preg_match ('/^6(?:011|5[0-9]{2})[0-9]{12}$/', $cc_number) // Discover
	) {
		$billing_errors['cc_number'] = 'Wpisz numer karty kredytowej!';
	}
	
	// Sprawdź datę ważności:
	if ( ($_POST['cc_exp_month'] < 1 || $_POST['cc_exp_month'] > 12)) {
		$billing_errors['cc_exp_month'] = 'Wpisz miesiąc ważności karty!';		
	}
	
	if ($_POST['cc_exp_year'] < date('Y')) {
		$billing_errors['cc_exp_year'] = 'Wpisz rok ważności karty!';
	}
	
	// Sprawdź pole numeru CVV:
	if (preg_match ('/^[0-9]{3,4}$/', $_POST['cc_cvv'])) {
		$cc_cvv = $_POST['cc_cvv'];
	} else {
		$billing_errors['cc_cvv'] = 'Wpisz numer CVV!';
	}
	
	// Sprawdź pole ulicy:
	if (preg_match ('/^[A-Z0-9 \',.#-]{2,160}$/i', $_POST['cc_address'])) {
		$cc_address  = $_POST['cc_address'];
	} else {
		$billing_errors['cc_address'] = 'Wpisz nazwę ulicy!';
	}
		
	// Sprawdź pole miasta:
	if (preg_match ('/^[A-Z \'.-]{2,60}$/i', $_POST['cc_city'])) {
		$cc_city = $_POST['cc_city'];
	} else {
		$billing_errors['cc_city'] = 'Wpisz nazwę miasta!';
	}
	
	// Sprawdź pole województwa:
	if (preg_match ('/^[A-Z]{2}$/', $_POST['cc_state'])) {
		$cc_state = $_POST['cc_state'];
	} else {
		$billing_errors['cc_state'] = 'Wpisz nazwę województwa!';
	}
	
	// Sprawdź pole kodu pocztowego:
	if (preg_match ('/^(^\d{2}-\d{3})$/', $_POST['cc_zip'])) {
		$cc_zip = $_POST['cc_zip'];
	} else {
		$billing_errors['cc_zip'] = 'Wpisz kod pocztowy!';
	}
	
	if (empty($billing_errors)) { // Jeśli wszystko w porządku...

		// Zmień format daty ważności karty na właściwy:
		$cc_exp = sprintf('%02d%d', $_POST['cc_exp_month'], $_POST['cc_exp_year']);
		
		// Sprawdź, czy istnieje zamówienie o danym identyfikatorze:
		if (isset($_SESSION['order_id'])) { // Skorzystaj z istniejących danych zamówienia:
			$order_id = $_SESSION['order_id'];
			$order_total = $_SESSION['order_total'];
		} else { // Utwórz nowy rekord zamówienia:
			
			// Pobierz cztery ostatnie cyfry numeru karty kredytowej:
			$cc_last_four = substr($cc_number, -4);

			// Wywołaj procedurę składowaną:
			$r = mysqli_query($dbc, "CALL add_order({$_SESSION['customer_id']}, '$uid', {$_SESSION['shipping']}, $cc_last_four, @total, @oid)");
			// Sprawdź, czy działa:
			if ($r) {

				// Pobierz identyfikator zamówienia i jego całkowitą wartość:
				$r = mysqli_query($dbc, 'SELECT @total, @oid');
				if (mysqli_num_rows($r) == 1) {
					list($order_total, $order_id) = mysqli_fetch_array($r);
					
					// Zapisz informacje w sesji:
					$_SESSION['order_total'] = $order_total;
					$_SESSION['order_id'] = $order_id;
					
				} else { // Nie można pobrać identyfikatora zamówienia i całkowitej wartości.
					unset($cc_number, $cc_cvv);
					trigger_error('Zamówienie nie może zostać przyjęte ze względu na błąd serwera. Przepraszamy za niedogodności.');
				}
			} else { // Błąd podczas wykonywania procedury add_order().
				unset($cc_number, $cc_cvv);
				trigger_error('Zamówienie nie może zostać przyjęte ze względu na błąd serwera. Przepraszamy za niedogodności.');
			}
			
		} // Koniec instrukcji IF-ELSE isset($_SESSION['order_id']).
		
		// ------------------------
		// Przetwórz płatność!
		if (isset($order_id, $order_total)) { 
				
				// Wymagany identyfikator użytkownika:
				$customer_id = $_SESSION['customer_id'];

				// Wykonaj żądanie do bramki płatności:
				require_once('../private/gateway_setup.php');
				require_once('../private/gateway_process.php');
				
				// Do dwóch wartości tekstowych dodaj ukośniki:
				$reason = addslashes($response_array[3]);
				$response = addslashes($response);

				// Zapisz transakcję:
				$r = mysqli_query($dbc, "CALL add_transaction($order_id, '{$data['x_type']}', $response_array[9], $response_array[0], '$reason', $response_array[6], '$response')");				
			
				// Po pomyślnym wykonaniu przekieruj:
				if ($response_array[0] == 1) {
					
					// Informację o transakcji dodaj do sesji:
					$_SESSION['response_code'] = $response_array[0];
					
					// Przekieruj do kolejnej strony:
					$location = 'https://' . BASE_URL . 'final.php';
					header("Location: $location");
					exit();

				} else { // W zależności od odpowiedzi, wykonaj odpowiednie działania:
					
					if ($response_array[0] == 2) { // Odrzucenie
						$message = $response_array[3] . ' Popraw błąd lub spróbuj użyć innej karty.';			
					} elseif ($response_array[0] == 3) { // Błąd
						$message = $response_array[3] . '  Popraw błąd lub spróbuj użyć innej karty.';			
					} elseif ($response_array[0] == 4) { // Zatrzymane do weryfikacji
						$message = "Transakcja została zatrzymana na czas sprawdzenia. Skontaktuje się z Tobą pracownik ASAC. Przepraszamy za niedogoności.";			
					}
					
				} // Koniec IF-ELSE $response_array[0].

		} // Koniec IF isset($order_id, $order_total).
		// Powyższy kod został dodany podczas pracy nad przetwarzaniem płatności.
		// ------------------------

	} // Koniec instrukcji IF obsługującej błędy.

} // Koniec IF REQUEST_METHOD.
							
// Dołącz plik nagłówka:
$page_title = 'Kawy świata - zamówienie - informacje dotyczące płatności';
include ('./includes/checkout_header.html');

// Pobierz zawartość koszyka:
$r = mysqli_query($dbc, "CALL get_shopping_cart_contents('$uid')");

if (mysqli_num_rows($r) > 0) { // Produkty do wyświetlenia!
	if (isset($_SESSION['shipping_for_billing']) && ($_SERVER['REQUEST_METHOD'] != 'POST')) {
		$values = 'SESSION';
	} else {
		$values = 'POST';
	}
	include ('./views/billing.html');
} else { // Wyczyść koszyk!
	include ('./views/emptycart.html');
}

// Dołącz stopkę:
include ('./includes/footer.html');
?>
