<?php

// Skrypt umożliwia administratorowi przeglądanie wszystkich zamówień.
// Skrypt jest tworzony w rozdziale 11.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na obsługę błędów.
require ('../includes/config.inc.php');

// Ustaw tytuł strony i dołącz plik nagłówka:
$page_title = 'View All Orders';
include ('./includes/header.html');
// W pliku nagłówka jest rozpoczynana sesja.

// Dołącz plik odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

echo '<h3>View Orders</h3><table border="0" width="100%" cellspacing="4" cellpadding="4">
<thead>
	<tr>
    <th align="center">Identyfikator zamówienia</th>
    <th align="center">Całkowita wartość</th>
    <th align="right">Klient</th>
    <th align="right">Miejscowość</th>
    <th align="center">Województwo</th>
    <th align="center">Kod pocztowy</th>
    <th align="center">Do wysłania</th>
  </tr></thead>
<tbody>';

// Utwórz kwerendę:
$q = 'SELECT o.id, total, c.id AS cid, CONCAT(last_name, ", ", first_name) AS name, city, state, zip, COUNT(oc.id) AS items FROM orders AS o LEFT OUTER JOIN order_contents AS oc ON (oc.order_id=o.id AND oc.ship_date IS NULL) JOIN customers AS c ON (o.customer_id = c.id) JOIN transactions AS t ON (t.order_id=o.id AND t.response_code=1) GROUP BY o.id DESC';

$r = mysqli_query ($dbc, $q);
while ($row = mysqli_fetch_array ($r, MYSQLI_ASSOC)) {
	echo '<tr>
    <td align="center"><a href="view_order.php?oid=' . $row['id'] . '">' . $row['id'] . '</a></td>
    <td align="center">$' . $row['total'] .'</td>
    <td align="right"><a href="view_customer.php?cid=' . $row['cid'] . '">' . $row['name'] .'</a></td>
    <td align="right">' . $row['city'] . '</td>
    <td align="center">' . $row['state'] .'</td>
    <td align="center">' . $row['zip'] .'</td>
    <td align="center">' . $row['items'] .'</td>
  </tr>';
}

echo '</tbody></table>';

// Dołącz stopkę.
include ('./includes/footer.html');
?>
