<?php

// Skrypt umożliwia administratorowi definiowanie promocji.
// Skrypt jest tworzony w rozdziale 11.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na obsługę błędów.
require_once ('../includes/config.inc.php');

// Ustaw tytuł strony i dołącz plik nagłówka:
$page_title = 'Create Sales';
include ('./includes/header.html');
// W pliku nagłówka jest rozpoczynana sesja.

// Dołącz plik odpowiedzialny za połączenie z bazą danych:
require_once(MYSQL);

// Sprawdź, czy formularz został przesłany:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {	
	
	// Sprawdź, czy zmienne są ustawione:
	if (isset($_POST['sale_price'], $_POST['start_date'], $_POST['end_date'])) {
		
		// Dołącz skrypt z funkcjami pomocnicznymi:
		require ('../includes/product_functions.inc.php');
		
		// Przygotuj kwerendę:
		$q = 'INSERT INTO sales (product_type, product_id, price, start_date, end_date) VALUES (?, ?, ?, ?, ?)';
		$stmt = mysqli_prepare($dbc, $q);
		mysqli_stmt_bind_param($stmt, 'sidss', $type, $id, $price, $start_date, $end_date);

		// Zmienna przechowująca liczbę zmodyfikowanych wierszy:
		$affected = 0;
		
		// Przejdź w pętli przez wszystkie dostarczone wartości:
		foreach ($_POST['sale_price'] as $sku => $price) {
			
			// Sprawdź cenę i datę rozpoczęcia:
			if (filter_var($price, FILTER_VALIDATE_FLOAT) 
			&& ($price > 0)
			&& (!empty($_POST['start_date'][$sku]))
			){
				
				// Przetwórz numer SKU:
				list($type, $id) = parse_sku($sku);
				
				// Pobierz daty:
				$start_date = $_POST['start_date'][$sku];
				$end_date = (empty($_POST['end_date'][$sku])) ? NULL : $_POST['end_date'][$sku];
				
				// Wykonaj kwerendę:
				mysqli_stmt_execute($stmt);
				$affected += mysqli_stmt_affected_rows($stmt);
				
			} // Koniec instrukcji IF sprawdzającej cenę i datę.
						
		} // Koniec pętli FOREACH.
		
		// Wyświetl rezultaty:
		echo "<h4>$affected promocji zostało zdefiniowanych!</h4>";
		
	} // Zmienne w $_POST nie zostały ustawione.

} // Koniec instrukcji IF sprawdzającej przesłanie formularza.
?>

<h3>Dodaj promocje</h3>
<p>W celu wystawienia produktu w promocji, podaj jego cenę promocyjną, datę rozpoczęcia oraz zakończenia promocji. Pola daty zakończenia nie musisz wypełniać. W takim przypadku będzie to promocja bezterminowa. Na poniższej liście znajdziesz tylko te produkty, które są aktualnie w sprzedaży!</p>
<form action="create_sales.php" method="post" accept-charset="utf-8">

	<fieldset>

<table border="0" width="100%" cellspacing="4 cellpadding="6">
	<thead>
	<tr>
		<th align="center">Produkt</th>
		<th align="center">Standardowa cena</th>
		<th align="center">Stan magazynowy</th>
		<th align="center">Cena promocyjna</th>
		<th align="center">Data rozpoczęcia</th>
		<th align="center">Data zakończenia</th>
	</tr>
	</thead>
	<tbody>

<?php // Pobierz wszystkie dostępne produkty:
$q = '(SELECT CONCAT("I", ncp.id) AS sku, ncc.category, ncp.name, ncp.price, ncp.stock FROM non_coffee_products AS ncp INNER JOIN non_coffee_categories AS ncc ON ncc.id=ncp.non_coffee_category_id WHERE ncp.stock > 0 ORDER BY category, name) UNION (SELECT CONCAT("K", sc.id), gc.category, CONCAT_WS(" - ", s.size, sc.caf_decaf, sc.ground_whole), sc.price, sc.stock FROM specific_coffees AS sc INNER JOIN sizes AS s ON s.id=sc.size_id INNER JOIN general_coffees AS gc ON gc.id=sc.general_coffee_id WHERE sc.stock > 0 ORDER BY sc.general_coffee_id, sc.size, sc.caf_decaf, sc.ground_whole)';
$r = mysqli_query ($dbc, $q);
while ($row = mysqli_fetch_array ($r, MYSQLI_ASSOC)) {
	echo '<tr>
    <td align="right">' . $row['category'] . '::' . $row['name'] . '</td>
    <td align="center">' . $row['price'] .'</td>
    <td align="center">' . $row['stock'] .'</td>
    <td align="center"><input type="text" name="sale_price[' . $row['sku'] . ']" class="small" /></td>
    <td align="center"><input type="text" name="start_date[' . $row['sku'] . ']" class="calendar" /></td>
    <td align="center"><input type="text" name="end_date[' . $row['sku'] . ']" class="calendar" /></td>
  </tr>';
}
?>

	</tbody></table>
	<div class="field"><input type="submit" value="Dodaj promocje" class="button" /></div>
	</fieldset>
</form>

<link href="/css/ui-lightness/jquery-ui-1.8.4.custom.css" rel="stylesheet" type="text/css" />
<script src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.5/jquery-ui.min.js" type="text/javascript" charset="utf-8"></script>
<script type="text/javascript">
	$(function() {
		$(".calendar").datepicker({dateFormat: "yy-mm-dd", minDate:0});
	});
	</script>

<?php
include ('./includes/footer.html');
?>
