<?php

// Skrypt umożliwia administratorowi zmianę stanu magazynowego.
// Skrypt jest tworzony w rozdziale 11.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na obsługę błędów.
require ('../includes/config.inc.php');

// Ustaw tytuł strony i dołącz plik nagłówka:
$page_title = 'Uzupełnij stan magazynowy';
include ('./includes/header.html');
// W pliku nagłówka jest rozpoczynana sesja.

// Dołącz plik odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Sprawdź, czy formularz został przesłany:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {	

	// Sprawdź, czy zmienił się stan magazynowy:
	if (isset($_POST['add']) && is_array($_POST['add'])) {
		
		// Dołącz skrypt z funkcjami pomocniczymi:
		require ('../includes/product_functions.inc.php');
		
		// Zdefiniuj dwie kwerendy:
		$q1 = 'UPDATE specific_coffees SET stock=stock+? WHERE id=?';
		$q2 = 'UPDATE non_coffee_products SET stock=stock+? WHERE id=?';

		// Przygotuj zapytania:
		$stmt1 = mysqli_prepare($dbc, $q1);
		$stmt2 = mysqli_prepare($dbc, $q2);
		
		// Powiąż zmienne:
		mysqli_stmt_bind_param($stmt1, 'ii', $qty, $id);
		mysqli_stmt_bind_param($stmt2, 'ii', $qty, $id);
		
		// Zmienna przechowująca liczbę zmienionych wierszy:
		$affected = 0;
		
		// Przejdź w pętli przez wszystkie przesłane wartości:
		foreach ($_POST['add'] as $sku => $qty) {
			
			// Sprawdź zmodyfikowane ilości:
			if (filter_var($qty, FILTER_VALIDATE_INT, array('min_range' => 1))) {

				// Przetwórz numer SKU:
				list($type, $id) = parse_sku($sku);
				
				// W zależności od typu produktu wykonaj odpowiednie zapytanie:
				if ($type == 'kawa') {
					// Wykonaj kwerendę:
					mysqli_stmt_execute($stmt1);
					
					// Dodaj do zmienionych wierszy:
					$affected += mysqli_stmt_affected_rows($stmt1);				

				} elseif ($type == 'inne') {
					// Wykonaj kwerendę:
					mysqli_stmt_execute($stmt2);
					
					// Dodaj do zmienionych wierszy:
					$affected += mysqli_stmt_affected_rows($stmt2);				

				}
				
			} // Koniec instrukcji IF.

		} // Koniec pętli FOREACH.
		
		// Wyświetl komunikat:
		echo "<h4>$affected produktów zostało zaktualizowanych!</h4>";

	} // Koniec instrukcji IF $_POST['add'].

} // Koniec instrukcji IF sprawdzającej przesłanie formularza.

?><h3>Uzupełnij stan magazynowy</h3>

<form action="add_inventory.php" method="post" accept-charset="utf-8">

	<fieldset><legend>Wpisz liczbę produktów dodawanych do magazynu.</legend>
	
		<table border="0" width="100%" cellspacing="4" cellpadding="4">
		<thead>
			<tr>
		    <th align="right">Produkt</th>
		    <th align="right">Standardowa cena</th>
		    <th align="right">Stan magazynowy</th>
		    <th align="center">Dodaj</th>
		  </tr></thead>
		<tbody>		
		<?php
		
		// Pobierz wszystkie produkty:
		$q = '(SELECT CONCAT("I", ncp.id) AS sku, ncc.category, ncp.name, ncp.price, ncp.stock FROM non_coffee_products AS ncp INNER JOIN non_coffee_categories AS ncc ON ncc.id=ncp.non_coffee_category_id ORDER BY category, name) UNION (SELECT CONCAT("K", sc.id), gc.category, CONCAT_WS(" - ", s.size, sc.caf_decaf, sc.ground_whole), sc.price, sc.stock FROM specific_coffees AS sc INNER JOIN sizes AS s ON s.id=sc.size_id INNER JOIN general_coffees AS gc ON gc.id=sc.general_coffee_id ORDER BY sc.general_coffee_id, sc.size, sc.caf_decaf, sc.ground_whole)';
		$r = mysqli_query ($dbc, $q);
		
		// Wyświetl pola formularza dla każdego produktu:
		while ($row = mysqli_fetch_array ($r, MYSQLI_ASSOC)) {
			echo '<tr>
		    <td align="right">' . $row['category'] . '::' . $row['name'] . '</td>
		    <td align="center">' . $row['price'] .'</td>
		    <td align="center">' . $row['stock'] .'</td>
		    <td align="center"><input type="text" name="add[' . $row['sku'] . ']"  id="add[' . $row['sku'] . ']" size="5" class="small" /></td>
		  </tr>';
		}
		
?>

	</tbody></table>
	<div class="field"><input type="submit" value="Add The Inventory" class="button" /></div>	
	</fieldset>
</form>

<?php
include ('./includes/footer.html');
?>
