<?php

// Skrypt wyświetla dostępne pliki PDF.
// Skrypt jest tworzony w rozdziale 5.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// Dołącz plik nagłówka:
$page_title = 'Dokumenty PDF';
include ('./includes/header.html');

// Wyświetl nagłówek:
echo '<h3>Dokumenty PDF</h3>';

// Wyświetl komunikat, jeżeli użytkownik nie ma aktywnego konta:
if (isset($_SESSION['user_id']) && !isset($_SESSION['user_not_expired'])) {
	echo '<p class="error">Dziękujemy za zainteresowanie artykułami. Niestety Twoje konto wygasło. <a href="renew.php">Odnów konto</a>, by uzyskać dostęp do przedstawionych dokumentów PDF.</p>';
} elseif (!isset($_SESSION['user_id'])) {
	echo '<p class="error">Dziękujemy za zainteresowanie artykułami. Musisz się zalogować, by uzyskać dostęp do przedstawionych dokumentów PDF.</p>';
}

// Pobierz listę plików PDF:
$q = 'SELECT tmp_name, title, description, size FROM pdfs ORDER BY date_created DESC';
$r = mysqli_query($dbc, $q);
if (mysqli_num_rows($r) > 0) { // Jeśli jakieś są...
	
	// Pobierz wszystkie:
	while ($row = mysqli_fetch_array ($r, MYSQLI_ASSOC)) {

		// Wyświetl wszystkie rekordy:
		echo "<div><h4><a href=\"view_pdf.php?id={$row['tmp_name']}\">{$row['title']}</a> ({$row['size']}kb)</h4><p>{$row['description']}</p></div>\n";

	} // Koniec pętli WHILE.
	
} else { // Brak PDF-ów!
	echo '<p>W tej chwili nie są dostępne żadne dokumenty PDF. Odwiedź nas za jakiś czas!</p>';
}

// Dołącz stopkę:
include ('./includes/footer.html');
?>
