<?php

// Skrypt wyświetla zawartość określonej strony.
// Skrypt jest tworzony w rozdziale 5.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku konfiguracyjnym rozpoczynana jest również sesja.

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// Sprawdź poprawność identyfikatora artykułu:
if (isset($_GET['id']) && filter_var($_GET['id'], FILTER_VALIDATE_INT, array('min_range' => 1))) {

	// Pobierz informacje o artykule:
	$q = 'SELECT title, description, content FROM pages WHERE id=' . $_GET['id'];
	$r = mysqli_query($dbc, $q);
	if (mysqli_num_rows($r) != 1) { // Problem!
		$page_title = 'Błąd!';
		include ('./includes/header.html');
		echo '<p class="error">Podczas próby dostępu do tej strony pojawił się błąd.</p>';
		include ('./includes/footer.html');
		exit();
	}
	
	// Pobierz informacje o stronie:
	$row = mysqli_fetch_array($r, MYSQLI_ASSOC);
	$page_title = $row['title'];
	include ('includes/header.html');
	echo "<h3>$page_title</h3>";
	
	// Wyświetl zawartość, jeśli konto użytkownika jest aktywne:
	if (isset($_SESSION['user_not_expired'])) {
		
		// Dodatkowy materiał zasygnalizowany z rozdziale 5.
		// Sprawdź, czy jest ulubione:
		$q = 'SELECT user_id FROM favorite_pages WHERE user_id=' . $_SESSION['user_id'] . ' AND page_id=' . $_GET['id'];
		$r = mysqli_query($dbc, $q);
		if (mysqli_num_rows($r) == 1) {
			echo '<p><img src="/images/heart_48.png" border="0" width="48" height="48" align="middle" /> To jest ulubione! <a href="remove_from_favorites.php?id=' . $_GET['id'] . '"><img src="/images/cross_48.png" border="0" width="48" height="48" align="middle" /></a></p>';
		} else {
			echo '<p>Ustaw jako ulubione! <a href="add_to_favorites.php?id=' . $_GET['id'] . '"><img src="/images/heart_48.png" border="0" width="48" height="48" align="middle" /></a>';
		}


		// Wyświetl zawartość strony:
		echo "<div>{$row['content']}</div>";
		
		// Dodatkowy materiał zasygnalizowany z rozdziale 5.
		// Record this visit to the history table:
		$q = "INSERT INTO history (user_id, type, page_id) VALUES ({$_SESSION['user_id']}, 'page', {$_GET['id']})";
		$r = mysqli_query($dbc, $q);
		
	} elseif (isset($_SESSION['user_id'])) { // Zalogowany, ale nieaktualne konto.
		echo '<p class="error">Dziękujemy za zainteresowanie artykułem. Niestety Twoje konto jest nieaktywne. <a href="renew.php">Odnów konto</a>, aby uzyskać pełny dostęp do zasobów.</p>';
		echo "<div>{$row['description']}</div>";
	} else { // Użytkownik nie jest zalogowany.
		echo '<p class="error">Dziękujemy za zainteresowanie artykułem, jednak aby uzyskać do niego dostęp, musisz się zalogować.</p>';
		echo "<div>{$row['description']}</div>";
	}

} else { // Niepoprawny identyfikator.
	$page_title = 'Błąd!';
	include ('includes/header.html');
	echo '<p class="error">Podczas próby dostępu do tej strony pojawił się błąd.</p>';
} // Koniec głównej instrukcji IF.

// Dołącz plik stopki:
include ('./includes/footer.html');
?>
