<?php

// Skrypt obsługuje mechanizm IPN (Instant Payment Notification) z systemu PayPal.
// Większość kodu pochodzi z dokumentacji PayPala.
// Skrypt jest tworzony w rozdziale 6.
// To jest zmodyfikowana wersja skryptu ipn.php, która zapisuje wszystkie transakcje w logu.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Otwórz plik tekstowy:
// Zmień ścieżkę na prawidłową wartość.
// PHP musi mieć możliwość zapisywania do pliku tekstowego!
$file = fopen('../ipn.txt', 'a');

// Do pliku zapisz dane z POST:
fwrite($file, "Received:\n");
fwrite($file, print_r($_POST, true));
fwrite($file, "\n");

// Utwórz zmienną żądania:
$req = 'cmd=_notify-validate';

// Do żądania dodaj wszystkie odebrane pary klucz=wartość:
foreach ($_POST as $key => $value) {
	$value = urlencode(stripslashes($value));
	$req .= "&$key=$value";
}

// Otwórz gniazdu w PayPal:
$fp = fsockopen ('ssl://www.sandbox.paypal.com', 443, $errno, $errstr, 30); // Test
//$fp = fsockopen ('ssl://www.paypal.com', 443, $errno, $errstr, 30); // Online

if (!$fp) { // Jeśli się nie da połączyć, wyślij e-mail:

	trigger_error('Could not connect for the IPN!');
	
} else { // Wyślij żądanie do PayPala:
	
	$header = "POST /cgi-bin/webscr HTTP/1.0\r\n";
	$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
	$header .= "Content-Length: " . strlen($req) . "\r\n\r\n";
	fputs ($fp, $header . $req);

	// Zapisz żądanie do pliku tekstowego:
	fwrite($file, "Sent:\n");
	fwrite($file, "$header\n");
	fwrite($file, "$req\n");
	
	// Odczytaj odpowiedź:
	while (!feof($fp)) {

		$res = fgets ($fp, 1024);

		// Zapisz odpowiedź do pliku tekstowego:
		fwrite($file, "Received:\n");
		fwrite($file, "$res\n");

		if (strcmp ($res, "VERIFIED") == 0) {
			
			// Sprawdź poprawność wartości:
			if ( ($_POST['payment_status'] == 'Completed')
			 && ($_POST['receiver_email'] == 'seller_1281297018_biz@mac.com')
			 && ($_POST['mc_gross'] == 10.00)
			 && ($_POST['mc_currency']  == 'USD') 
			 && (!empty($_POST['txn_id']))
			) {
				
				// Dołącz plik odpowiedzialny za połączenie z bazą danych:
				require(MYSQL);
				
				// Sprawdź, czy transakcja jest już zapisana w bazie:
				$txn_id = mysqli_real_escape_string($dbc, $_POST['txn_id']);				
				$q = "SELECT id FROM orders WHERE transaction_id='$txn_id'";
				$r = mysqli_query ($dbc, $q);
				if (mysqli_num_rows($r) == 0) { // Dodaj nową transakcję:
					
					$uid = (int) $_POST['custom'];
					$status = mysqli_real_escape_string($dbc, $_POST['payment_status']);
					$amount = (float) $_POST['mc_gross'];
					$q = "INSERT INTO orders (user_id, transaction_id, payment_status, payment_amount) VALUES ($uid, '$txn_id', '$status', $amount)";
					$r = mysqli_query ($dbc, $q);
					if (mysqli_affected_rows($dbc) == 1) {
						
						// Zaktualizuj tabelę users:
						$q = "UPDATE users SET date_expires = IF(date_expires > NOW(), ADDDATE(date_expires, INTERVAL 1 YEAR), ADDDATE(NOW(), INTERVAL 1 YEAR)), date_modified=NOW() WHERE id=$uid";
						$r = mysqli_query ($dbc, $q);
						if (mysqli_affected_rows($dbc) != 1) {
							trigger_error('Data wygaśnięcia konta nie może zostać zaktualizowana!');
						}
						
					} else { // Problem inserting the order!
						trigger_error('Transakcja nie może zostać zapisana w tabeli orders!');						
					}
					
				} // Zamówienie zostało już wcześniej zapisane!
				
			} // W tablicy $_POST nie ma prawidłowych wartości!

		} elseif (strcmp ($res, "INVALID") == 0) {
			// Zapisz w logu
		}

	} // Koniec pętli WHILE.
	
	// Zamknij połączenie:
	fclose ($fp);

} // Koniec IF-ELSE $fp.

// Dodaj separator transakcji w pliku tekstowym:
fwrite($file, "--------------\n");
fclose($file);

?>
