<?php

// Skrypt obsługuje mechanizm IPN (Instant Payment Notification) z systemu PayPal.
// Większość kodu pochodzi z dokumentacji PayPala.
// Skrypt jest tworzony w rozdziale 6.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Utwórz zmienną żądania:
$req = 'cmd=_notify-validate';

// Do odpowiedzi dodaj wszystkie otrzymane pary klucz=wartość:
foreach ($_POST as $key => $value) {
	$value = urlencode(stripslashes($value));
	$req .= "&$key=$value";
}

// Otwórz gniazdo w systemie PayPal:
$fp = fsockopen ('ssl://www.sandbox.paypal.com', 443, $errno, $errstr, 30); // Środowisko testowe
//$fp = fsockopen ('ssl://www.paypal.com', 443, $errno, $errstr, 30); // Środowisko produkcyjne

if (!$fp) { // Jeśli nie można się połączyć, wyślij e-mail:

	trigger_error('Połączenie z IPN jest w tej chwili niemożliwe!');
	
} else { // Wyślij żądanie do PayPala:
	
	$header = "POST /cgi-bin/webscr HTTP/1.0\r\n";
	$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
	$header .= "Content-Length: " . strlen($req) . "\r\n\r\n";
	fputs ($fp, $header . $req);

	// Odczytaj odpowiedź:
	while (!feof($fp)) {

		$res = fgets ($fp, 1024);

		if (strcmp ($res, "VERIFIED") == 0) {
			
			// Sprawdź poprawność wartości:
			if ( isset($_POST['payment_status'])
			 && ($_POST['payment_status'] == 'Completed')
			 && ($_POST['receiver_email'] == 'seller_1299622838_biz@gmail.com')
			 && ($_POST['mc_gross'] == 50.00)
			 && ($_POST['mc_currency']  == 'PLN') 
			 && (!empty($_POST['txn_id']))
			) {
				
				// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
				require(MYSQL);
				
				// Sprawdź, czy transakcja jest zapisana w bazie danych:
				$txn_id = mysqli_real_escape_string($dbc, $_POST['txn_id']);				
				$q = "SELECT id FROM orders WHERE transaction_id='$txn_id'";
				$r = mysqli_query ($dbc, $q);
				if (mysqli_num_rows($r) == 0) { // Dodaj nową transakcję:
					
					$uid = (isset($_POST['custom'])) ? (int) $_POST['custom'] : 0;
					$status = mysqli_real_escape_string($dbc, $_POST['payment_status']);
					$amount = (float) $_POST['mc_gross'];
					$q = "INSERT INTO orders (user_id, transaction_id, payment_status, payment_amount) VALUES ($uid, '$txn_id', '$status', $amount)";
					$r = mysqli_query ($dbc, $q);
					if (mysqli_affected_rows($dbc) == 1) {
						
						if ($uid > 0) {
							
							// Zaktualizuj tabelę users:
							$q = "UPDATE users SET date_expires = IF(date_expires > NOW(), ADDDATE(date_expires, INTERVAL 1 YEAR), ADDDATE(NOW(), INTERVAL 1 YEAR)), date_modified=NOW() WHERE id=$uid";
							$r = mysqli_query ($dbc, $q);
							if (mysqli_affected_rows($dbc) != 1) {
								trigger_error('Data wygaśnięcia konta nie może zostać zaktualizowana!');
							}
							
						} // Nieprawidłowy identyfikator użytkownika.
						
					} else { // Problem ze wstawieniem zamówienia!
						trigger_error('Transakcja nie może zostać zapisana w tabeli orders!');						
					}
					
				} // Zamówienie zostało już wcześniej zapisane!
				
			} // W tablicy $_POST nie ma prawidłowych danych!

		} elseif (strcmp ($res, "INVALID") == 0) {
			// Zapisz w logu
		}

	} // Koniec pętli WHILE.
	
	// Zamknij połączenie:
	fclose ($fp);

} // Koniec IF-ELSE $fp.

?>
