<?php

// A more formal comments structure, only used in this one page but could (should) be used everywhere:
/* 	*
	* Title: config.inc.php
	* Created by: Larry E. Ullman of DMC Insights, Inc. 
	* Contact: Larry@DMCInsights.com, http://www.dmcinsights.com
	* Last modified: 07-28-2010
	*
	* Configuration file does the following things:
	* - Has site settings in one location.
	* - Stores URLs and URIs as constants.
	* - Starts the session.
	* - Sets how errors will be handled.
	* - Defines a redirection function.
	*
	* This script is begun in Chapter 3.
*/

// ********************************** //
// ************ USTAWIENIA ********** //

// Czy witryna jest online?
$live = false;

// Adres e-mailowy, na który są wysyłane komunikaty o błędach:
$contact_email = 'you@example.com';

// ************ USTAWIENIA ********** //
// ********************************** //

// ********************************** //
// ************** STAŁE ************* //

// Lokalizacja plików i adres URL witryny:
define ('BASE_URI', '../');
define ('BASE_URL', 'www.example.com/');
define ('PDFS_DIR', BASE_URI . 'pdfs/'); // Dodane w rozdziale 5.
define ('MYSQL', BASE_URI . 'mysql.inc.php');

// ************** STAŁE ************* //
// ********************************** //

// ********************************* //
// ************** SESJE ************ //

// Rozpocznij sesję:
session_start();

// ************ SESJE ************** //
// ********************************* //

// ****************************************** //
// ************ ZARZĄDZANIE BŁĘDAMI ********* //

// Funkcja obsługująca błędy.
// Przyjmuje pięć argumentów: numer błędu, komunikat (łańcuch znaków),
// nazwa pliku, w którym wystąpił błąd (łańcuch znaków),
// numer wiersza, w którym wystąpił błąd oraz istniejące zmienne (tablica).
// Zwraca wartość true.
function my_error_handler ($e_number, $e_message, $e_file, $e_line, $e_vars) {

	// Te dwie zmienne są potrzebne:
	global $live, $contact_email;
	
	// Skonstruuj komunikat o błędzie:
	$message = "Wystąpił błąd w skrypcie '$e_file' w wierszu $e_line:\n$e_message\n";
	
	// Wstaw dodatkowe informacje o wykonaniu:
	$message .= "<pre>" .print_r(debug_backtrace(), 1) . "</pre>\n";
	
	// lub po prostu dołącz zmienną $e_vars do komunikatu:
	//	$message .= "<pre>" . print_r ($e_vars, 1) . "</pre>\n";

	if (!$live) { // Wyświetl komunikat w przeglądarce.
		
		echo '<div class="error">' . nl2br($message) . '</div>';

	} else { // Etap wytwarzania (wyświetl błąd).

		// Wyślij komunikat na adres e-mailowy:
		error_log ($message, 1, $contact_email, 'From:admin@example.com');
		
		// Jeśli błąd jest ostrzeżeniem, wyświetl go tylko w przeglądarce:
		if ($e_number != E_NOTICE) {
			echo '<div class="error">Wystąpił błąd systemowy. Przepraszamy za niedogodności.</div>';
		}

	} // Koniec IF-ELSE $live.
	
	return true; // Tak by PHP nie starało się samo obsłużyć tego błędu.

} // Koniec funkcji my_error_handler().

// Zastosuj funkcję obsługi błędów:
set_error_handler ('my_error_handler');

// ************ OBSŁUGA BŁĘDÓW ************ //
// ****************************************** //

// ******************************************* //
// ************ FUNCKJA PRZEKIEROWUJĄCA ************ //

// Ten blok kodu jest dodawany w rozdziale 4.

// Funkcja przekierowuje nieuprawnionych użytkowników.
// Przyjmuje dwa argumenty: 
// - Element tablicy sesji, który ma zostać sprawdzony
// - Docelowa strona, na którą ma zostać przekierowany użytkownik 
function redirect_invalid_user($check = 'user_id', $destination = 'index.php', $protocol = 'http://') {
	
	// Sprawdź element tablicy sesji:
	if (!isset($_SESSION[$check])) {
		$url = $protocol . BASE_URL . $destination; // Zdefiniuj URL.
		header("Location: $url");
		exit(); // Zakończ wykonywanie skryptu.
	}
	
} // Koniec funkcji redirect_invalid_user().

// Pomiń zamykający znacznik PHP, aby uniknąć błędów wynikających z przesłanego nagłówka (headers already sent)!
