<?php

// Ta strona jest wykorzystywana przez administratora do tworzenia stron z zawartością HTML.
// Skrypt jest tworzony w rozdziale 5.

// Przed kodem PHP dołącz plik konfiguracyjny, ponieważ znajduje się w nim funkcja obsługi błędów:
require ('./includes/config.inc.php');

// Jeśli użytkownik nie jest zalogowany jako administrator, przekieruj go:
redirect_invalid_user('user_admin');

// Dołącz plik nagłówka:
$page_title = 'Dodaj stronę z zawartością';
include ('./includes/header.html');

// Dołącz wymagany skrypt odpwoiedzialny za połączenie z bazą danych:
require(MYSQL);

// Tablica przechowująca błędy:
$add_page_errors = array();

// Sprawdź, czy formularz został przesłany:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {	
	
	// Sprawdź wartość z pola tytułu:
	if (!empty($_POST['title'])) {
		$t = mysqli_real_escape_string($dbc, strip_tags($_POST['title']));
	} else {
		$add_page_errors['title'] = 'Wpisz tytuł!';
	}
	
	// Sprawdź wartość z pola kategorii:
	if (filter_var($_POST['category'], FILTER_VALIDATE_INT, array('min_range' => 1))) {
		$cat = $_POST['category'];
	} else { // Nie wybrano żadnej kategorii.
		$add_page_errors['category'] = 'Wybierz kategorię!';
	}

	// Sprawdź wartość z pola opisu:
	if (!empty($_POST['description'])) {
		$d = mysqli_real_escape_string($dbc, strip_tags($_POST['description']));
	} else {
		$add_page_errors['description'] = 'Wprowadź opis!';
	}
		
	// Sprawdź wartość z pola głównej treści:
	if (!empty($_POST['content'])) {
		$allowed = '<div><p><span><br><a><img><h1><h2><h3><h4><ul><ol><li><blockquote>';
		$c = mysqli_real_escape_string($dbc, strip_tags($_POST['content'], $allowed));
	} else {
		$add_page_errors['content'] = 'Wprowadź treść!';
	}
		
	if (empty($add_page_errors)) { // Jeśli wszystko jest w porządku.
	
		// Dodaj artykuł do bazy danych:
		$q = "INSERT INTO pages (category_id, title, description, content) VALUES ($cat, '$t', '$d', '$c')";
		$r = mysqli_query ($dbc, $q);

		if (mysqli_affected_rows($dbc) == 1) { // Jeśli zostało prawidłowo wykonane.
		
			// Wyświetl komunikat:
			echo '<h4>Strona została dodana!</h4>';
			
			// Wyczyść tablicę $_POST:
			$_POST = array();
			
			// Do administratora wyślij e-mail informujący o dodaniu zawartości.
			
		} else { // Jeśli nie udało się prawidłowo wykonać kwerendy.
			trigger_error('Strona nie została dodana ze względu na błąd systemu. Przepraszamy za kłopot.');
		}
		
	} // Koniec instrukcji IF $add_page_errors.
	
} // Koniec głównego warunku związanego z przesyłaniem formularza.

// Wymagany jest skrypt zawierający funkcję create_form_input():
require ('includes/form_functions.inc.php');
?>
<h3>Dodaj stronę z zawartością</h3>
<form action="add_page.php" method="post" accept-charset="utf-8">

	<fieldset><legend>Aby dodać stronę, wypełnij pola formularza:</legend>
	
		<p><label for="title"><strong>Tytuł</strong></label><br /><?php create_form_input('title', 'text', $add_page_errors); ?></p>
	
	<p><label for="category"><strong>Kategoria</strong></label><br />
	<select name="category"<?php if (array_key_exists('category', $add_page_errors)) echo ' class="error"'; ?>>
	<option>Wybierz kategorię</option>
	<?php // Pobierz wszystkie kategorie i dodaj je do rozwijanej listy:
	$q = "SELECT id, category FROM categories ORDER BY category ASC";		
	$r = mysqli_query ($dbc, $q);
		while ($row = mysqli_fetch_array ($r, MYSQLI_NUM)) {
			echo "<option value=\"$row[0]\"";
			if (isset($_POST['category']) && ($_POST['category'] == $row[0]) ) echo ' selected="selected"';
			echo ">$row[1]</option>\n";
		}
	?>
	</select><?php if (array_key_exists('category', $add_page_errors)) echo ' <span class="error">' . $add_page_errors['category'] . '</span>'; ?></p>
	
	<p><label for="description"><strong>Opis</strong></label><br /><?php create_form_input('description', 'textarea', $add_page_errors); ?></p>
	
	<p><label for="content"><strong>Treść</strong></label><br /><?php create_form_input('content', 'textarea', $add_page_errors); ?></p>
	
	<p><input type="submit" name="submit_button" value="Dodaj stronę" id="submit_button" class="formbutton" /></p>
	
	</fieldset>

</form> 

<script type="text/javascript" src="tiny_mce/tiny_mce.js"></script>
<script type="text/javascript">
	tinyMCE.init({
		// Ogólne opcje
		mode : "exact",
		elements : "content",
		theme : "advanced",
		width : 800,
		height : 400,
		plugins : "advlink,advlist,autoresize,autosave,contextmenu,fullscreen,iespell,inlinepopups,media,paste,preview,safari,searchreplace,visualchars,wordcount,xhtmlxtras",

		// Opcje związane z wyglądem
		theme_advanced_buttons1 : "cut,copy,paste,pastetext,pasteword,|,undo,redo,removeformat,|,search,replace,|,cleanup,help,code,preview,visualaid,fullscreen",
		theme_advanced_buttons2 : "bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,formatselect,|,bullist,numlist,|,outdent,indent,blockquote,|,sub,sup,cite,abbr",
		theme_advanced_buttons3 : "hr,|,link,unlink,anchor,image,|,charmap,emotions,iespell,media",
		theme_advanced_toolbar_location : "top",
		theme_advanced_toolbar_align : "left",
		theme_advanced_statusbar_location : "bottom",
		theme_advanced_resizing : true,

		// Przykładowy CSS dla zawartości (powinien to być arkusz CSS witryny)
		content_css : "/css/style.css",

	});
</script>
<!-- /TinyMCE -->

<?php /* KONIEC TREŚCI STRONY */

// Dołącz plik stopki:
include ('./includes/footer.html');
?>
