<?php

// Skrypt odpowiada za wyświetlenie listy produtów z danej kategorii.
// Praca nad skryptem rozpoczyna się w rozdziale 8.

// Dołącz plik konfiguracyjny przed kodem PHP:
require ('./includes/config.inc.php');

// Sprawdź wymagane wartości:
$type = $sp_type = $sp_cat = $category = false;
if (isset($_GET['type'], $_GET['category'], $_GET['id']) && filter_var($_GET['id'], FILTER_VALIDATE_INT, array('min_range' => 1))) {
	
	// Utwórz powiązania:
	$category = $_GET['category'];
	$sp_cat = $_GET['id'];
	
	// Sprawdź typ:
	if ($_GET['type'] == 'gadzety') {
		
		$sp_type = 'inne';
		$type = 'gadzety';
		
	} elseif ($_GET['type'] == 'kawa') {
		
		$type = $sp_type = 'kawa';	
		
	}

}

// Jeśli wystąpi problem, wyświetl stronę z opisem błędu:
if (!$type || !$sp_type || !$sp_cat || !$category) {
	$page_title = 'Błąd!';
	include ('./includes/header.html');
	include ('./views/error.html');
	include ('./includes/footer.html');
	exit();
}

// Utwórz tytuł strony:
$page_title = ucfirst($type) . ' to Buy::' . $category;

// Dołącz plik nagłówka:
include ('./includes/header.html');

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Wywołaj procedurę składowaną:
$r = mysqli_query($dbc, "CALL select_products('$sp_type', $sp_cat)");

// Na potrzeby debugowania:
if (!$r) echo mysqli_error($dbc);

// Jeśli zostały zwrócone jakieś rekordy, dołącz plik widoku:
if (mysqli_num_rows($r) > 0) {
	if ($type == 'goodies') {
		// Trzy wersje pliku:
//		include ('./views/list_products.html');
//		include ('./views/list_products2.html');
		include ('./views/list_products3.html');
	} elseif ($type == 'coffee') {
//		include ('./views/list_coffees.html');
		include ('./views/list_coffees2.html');
	}
} else { // Dołącz plik strony z brakiem produktów ("noproducts"):
	include ('./views/noproducts.html');
}

// Dołącz plik stopki:
include ('./includes/footer.html');
?>
