<?php

// Skrypt umożliwia administratorowi dodawanie produktów.
// Skrypt jest tworzony w rozdziale 11.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na obsługę błędów.
require ('../includes/config.inc.php');

// Ustaw tytuł strony i dołącz plik nagłówka:
$page_title = 'Add a Goodie';
include ('./includes/header.html');
// W pliku nagłówka jest rozpoczynana sesja.

// Dołącz plik odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// Tablica błędów:
$add_product_errors = array();

// Sprawdź, czy formularz został przesłany:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {	

	// Sprawdź kategorię:
	if (!isset($_POST['category']) || !filter_var($_POST['category'], FILTER_VALIDATE_INT, array('min_range' => 1))) {
		$add_product_errors['category'] = 'Wybierz kategorię!';
	}

	// Sprawdź cenę:
	if (empty($_POST['price']) || !filter_var($_POST['price'], FILTER_VALIDATE_FLOAT) || ($_POST['price'] <= 0)) {
		$add_product_errors['price'] = 'Podaj cenę!';
	}

	// Sprawdź stan magazynowy:
	if (empty($_POST['stock']) || !filter_var($_POST['stock'], FILTER_VALIDATE_INT, array('min_range' => 1))) {
		$add_product_errors['stock'] = 'Podaj stan magazynowy!';
	}

	// Sprawdź nazwę:
	if (empty($_POST['name'])) {
		$add_product_errors['name'] = 'Podaj nazwę!';
	}
	
	// Sprawdź opis:
	if (empty($_POST['description'])) {
		$add_product_errors['description'] = 'Wprowadź opis!';
	}

	// Sprawdź obrazek:
	if (is_uploaded_file ($_FILES['image']['tmp_name']) && ($_FILES['image']['error'] == UPLOAD_ERR_OK)) {
		
		$file = $_FILES['image'];
		
		$size = ROUND($file['size']/1024);

		// Sprawdź rozmiar pliku:
		if ($size > 512) {
			$add_product_errors['image'] = 'Plik jest za duży.';
		} 

		// Sprawdź typ pliku:
		$allowed_mime = array ('image/gif', 'image/pjpeg', 'image/jpeg', 'image/JPG', 'image/X-PNG', 'image/PNG', 'image/png', 'image/x-png');
		$allowed_extensions = array ('.jpg', '.gif', '.png', 'jpeg');
		$image_info = getimagesize($file['tmp_name']);
		$ext = substr($file['name'], -4);
		if ( (!in_array($file['type'], $allowed_mime)) 
		||   (!in_array($image_info['mime'], $allowed_mime) ) 
		||   (!in_array($ext, $allowed_extensions) ) 
		) {
			$add_product_errors['image'] = 'Plik jest niewłaściwego typu.';
		} 
		
		// Przenieś plik, jeśli nie wystąpiły problemy:
		if (!array_key_exists('image', $add_product_errors)) {

			// Utwórz nową nazwę dla pliku:
			$new_name = (string) sha1($file['name'] . uniqid('',true));

			// Dodaj rozszerzenie:
			$new_name .= ((substr($ext, 0, 1) != '.') ? ".{$ext}" : $ext);

			// Przenieś plik do właściwej lokalizacji, ale na wszelki wypadek dodaj przedstostek _tmp:
			$dest =  "../products/$new_name";
			
			if (move_uploaded_file($file['tmp_name'], $dest)) {
				
				// Zapisz dane w sesji:
				$_SESSION['image']['new_name'] = $new_name;
				$_SESSION['image']['file_name'] = $file['name'];
				
				// Wyświetl komunikat:
				echo '<h4>Plik został przesłany!</h4>';
				
			} else {
				trigger_error('Plik nie może zostać przeniesiony.');
				unlink ($file['tmp_name']);				
			}

		} // Koniec instrukcji IF array_key_exists().
		
	} elseif (!isset($_SESSION['image'])) { // Brak przesłanego pliku.
		switch ($_FILES['image']['error']) {
			case 1:
			case 2:
				$add_product_errors['image'] = 'Plik jest za duży.';
				break;
			case 3:
				$add_product_errors['image'] = 'Przesłano tylko część pliku.';
				break;
			case 6:
			case 7:
			case 8:
				$add_product_errors['image'] = 'Nie można przesłać pliku ze względu na błąd systemu.';
				break;
			case 4:
			default: 
				$add_product_errors['image'] = 'Plik nie został przesłany.';
				break;
		} // Koniec instrukcji SWITCH.

	} // Koniec instrukcji IF-ELSEIF-ELSE $_FILES .
	
	if (empty($add_product_errors)) { // Jeśli wszystko OK.

		// Dodaj produkt do bazy danych:
		$q = 'INSERT INTO non_coffee_products (non_coffee_category_id, name, description, image, price, stock) VALUES (?, ?, ?, ?, ?, ?)';

		// Przygotuj kwerendę:
		$stmt = mysqli_prepare($dbc, $q);
		
		// Na potrzeby debugowania:
		// if (!$stmt) echo mysqli_stmt_error($stmt);

		// Powiąż zmienne:
		mysqli_stmt_bind_param($stmt, 'isssdi', $_POST['category'], $name, $desc, $_SESSION['image']['new_name'], $_POST['price'], $_POST['stock']);
		
		// Utwórz dodatkowe powiązanie między zmiennymi:
		$name = strip_tags($_POST['name']);
		$desc = strip_tags($_POST['description']);

		// Wykonaj kwerendę:
		mysqli_stmt_execute($stmt);
		
		if (mysqli_stmt_affected_rows($stmt) == 1) { // If it ran OK.
			
			// Wyświetl komunikat:
			echo '<h4>Produkt został dodany!</h4>';
		
			// Wyczyść tablicę $_POST:
			$_POST = array();
			
			// Wyczyść tablicę $_FILES:
			$_FILES = array();
			
			// Wyczyść zmienną $file i $_SESSION['image']:
			unset($file, $_SESSION['image']);
					
		} else { // Jeśli się nie powiodło.
			trigger_error('Produkt nie może zostać dodany ze względu na błąd systemu. Przepraszamy za niedogodności.');
			unlink ($dest);
		}
				
	} // Koniec instrukcji IF $errors.
	
} else { // Wyczyść sesję w przypadku żądania GET:
	unset($_SESSION['image']);	
} // Koniec instrukcji IF.

// Dołącz skrypt zawierający funkcję create_form_input():
require ('../includes/form_functions.inc.php');
?><h3>Dodaj inny produkt (gadżet)</h3>

<form enctype="multipart/form-data" action="add_other_products.php" method="post" accept-charset="utf-8">

	<input type="hidden" name="MAX_FILE_SIZE" value="524288" />
	
	<fieldset><legend>Formularz umożliwia dodanie produktu do katalogu gadżetów. Wymagane jest wypełnienie wszystkich pól.</legend>
		<div class="field"><label for="category"><strong>Kategoria</strong></label><br /><select name="category"<?php if (array_key_exists('category', $add_product_errors)) echo ' class="error"'; ?>>
			<option>Wybierz...</option>
			<?php // Pobierz wszystkie kategorie i dodaj je do rozwijalnej listy wyboru:
			$q = 'SELECT id, category FROM non_coffee_categories ORDER BY category ASC';		
			$r = mysqli_query ($dbc, $q);
				while ($row = mysqli_fetch_array ($r, MYSQLI_NUM)) {
					echo "<option value=\"$row[0]\"";
					if (isset($_POST['category']) && ($_POST['category'] == $row[0]) ) echo ' selected="selected"';
					echo ">$row[1]</option>\n";
				}
			?>
			</select><?php if (array_key_exists('category', $add_product_errors)) echo ' <span class="error">' . $add_product_errors['category'] . '</span>'; ?></div>
		
			<div class="field"><label for="name"><strong>Nazwa</strong></label><br /><?php create_form_input('name', 'text', $add_product_errors); ?></div>
		
			<div class="field"><label for="price"><strong>Cena</strong></label><br /><?php create_form_input('price', 'text', $add_product_errors); ?> <small>Without the dollar sign.</small></div>
	
			<div class="field"><label for="stock"><strong>Początkowy stan magazynowy</strong></label><br /><?php create_form_input('stock', 'text', $add_product_errors); ?></div>
			
			<div class="field"><label for="description"><strong>Opis</strong></label><br /><?php create_form_input('description', 'textarea', $add_product_errors); ?></div>

			<div class="field"><label for="image"><strong>Obrazek</strong></label><br /><?php
		
			// Sprawdź błędy:
			if (array_key_exists('image', $add_product_errors)) {
				
				echo '<span class="error">' . $add_product_errors['image'] . '</span><br /><input type="file" name="image" class="error" />';
				
			} else { // Bez błędów.

				echo '<input type="file" name="image" />';

				if (isset($_SESSION['image'])) {
					echo "<br />Obecnie '{$_SESSION['image']['file_name']}'";
				}

			} // Koniec instrukcji IF-ELSE sprawdzającej błędy.
		 ?></div>
	
	<br clear="all" />
	
	<div class="field"><input type="submit" value="Dodaj produkt" class="button" /></div>
	
	
	</fieldset>

</form> 

<?php // Dołącz stopkę:
include ('./includes/footer.html');
?>
