<?php

// This pages retrieves and shows a PDF.
// This script is created in Chapter 5.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require(MYSQL);

// Załóż, że informacje nie są prawidłowe:
$valid = false;

// Sprawdź identyfikator pliku PDF:
if (isset($_GET['id']) && (strlen($_GET['id']) == 40) && (substr($_GET['id'], 0, 1) != '.') ) {

	// Określ plik:
	$file = PDFS_DIR . $_GET['id'];

	// Sprawdź, czy określony PDF istnieje, i czy to plik:
	if (file_exists ($file) && (is_file($file)) ) {

		// Pobierz informację:
		$q = 'SELECT id, title, description, file_name FROM pdfs WHERE tmp_name="' . mysqli_real_escape_string($dbc, $_GET['id']) . '"';
		$r = mysqli_query($dbc, $q);
		if (mysqli_num_rows($r) == 1) { // Ok!
			
			// Pobierz informację:
			$row = mysqli_fetch_array($r, MYSQLI_ASSOC);
			
			// Plik jest OK:
			$valid = true;
			
			// Dokument PDF trafia tylko do aktywnych użytkowników:
			if (isset($_SESSION['user_not_expired'])) {

				// Dodatek opisany w rozdziale 5.
				// Zapisz wizytę w tabeli historii:
				$q = "INSERT INTO history (user_id, type, pdf_id) VALUES ({$_SESSION['user_id']}, 'pdf', {$row['id']})";
				$r = mysqli_query($dbc, $q);

				
				// Wyślij informacje o zawartości:
				header('Content-type:application/pdf'); 
				header('Content-Disposition:inline;filename="' . $row['file_name'] . '"'); 
				$fs = filesize($file);
				header ("Content-Length:$fs\n");

				// Wyślij plik:
				readfile ($file);
				exit();
				
			} else { // Nieaktywne konto!
				
				// W zamian wyświetl stronę HTML:
				$page_title = $row['title'];
				include ('./includes/header.html');
				echo "<h3>$page_title</h3>";
				
				// Zmień komunikat na podstawie statusu użytkownika:
				if (isset($_SESSION['user_id'])) {
					echo '<p class="error">Dziękujemy za zainteresowanie artykułami. Niestety Twoje konto wygasło. <a href="renew.php">Odnów konto</a>, by uzyskać dostęp do przedstawionych dokumentów PDF.</p>';
				} else {
					echo '<p class="error">Dziękujemy za zainteresowanie artykułami. Musisz się zalogować, by uzyskać dostęp do przedstawionych dokumentów PDF.</p>';
				}
				
				// Zakończ kod strony:
				echo "<div>{$row['description']}</div>";
				include ('./includes/footer.html');	
				
			} // Koniec IF-ELSE użytkownika.
					
		} // Koniec IF mysqli_num_rows().

	} // Koniec IF file_exists().
	
} // End of $_GET['id'] IF.

// Jeśli coś jest nie tak...
if (!$valid) {
	$page_title = 'Błąd!';
	include ('./includes/header.html');
	echo '<p class="error">Podczas dostępu do strony wystąpił błąd.</p>';
	include ('./includes/footer.html');	
}
?>
