<?php

// Skrypt służy do zmiany hasła.
// Użytkownicy muszą być zalogowani, by uzyskać dostęp do strony.
// Skrypt jest tworzony w rozdziale 4.

// Dołącz plik konfiguracyjny przed kodem PHP ze względu na funkcję obsługi błędów:
require ('./includes/config.inc.php');
// W pliku jest również rozpoczynana sesja.

// Jeśli użytkownik nie jest zalogowany, przekieruj go:
redirect_invalid_user();

// Dołącz plik nagłówka:
$page_title = 'Zmiana hasła';
include ('./includes/header.html');

// Dołącz skrypt odpowiedzialny za połączenie z bazą danych:
require (MYSQL);

// Tablica błędów:
$pass_errors = array();

// Jeśli to żądanie POST, obsłuż formularz:
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
			
	// Sprawdź pole dotychczasowego hasła:
	if (!empty($_POST['current'])) {
		$current = mysqli_real_escape_string ($dbc, $_POST['current']);
	} else {
		$pass_errors['current'] = 'Wpisz dotychczasowe hasło!';
	}
	
	// Sprawdź pole nowego hasła i zweryfikuj je z drugim polem:
	if (preg_match ('/^(\w*(?=\w*\d)(?=\w*[a-z])(?=\w*[A-Z])\w*){6,20}$/', $_POST['pass1']) ) {
		if ($_POST['pass1'] == $_POST['pass2']) {
			$p = mysqli_real_escape_string ($dbc, $_POST['pass1']);
		} else {
			$pass_errors['pass2'] = 'Wprowadzone hasła nie są identyczne!';
		}
	} else {
		$pass_errors['pass1'] = 'Wpisz prawidłowe hasło!';
	}
	
	if (empty($pass_errors)) { // Jeżeli wszystko w porządku.
	
		// Sprawdź dotychczasowe hasło:
		$q = "SELECT id FROM users WHERE pass='"  .  get_password_hash($current) .  "' AND id={$_SESSION['user_id']}";	
		$r = mysqli_query ($dbc, $q);
		if (mysqli_num_rows($r) == 1) { // Prawidłowe
			
			// Zdefiniuj kwerendę:
			$q = "UPDATE users SET pass='"  .  get_password_hash($p) .  "' WHERE id={$_SESSION['user_id']} LIMIT 1";	
			if ($r = mysqli_query ($dbc, $q)) { // Jeżeli OK.

				// Jeśli trzeba, wyślij e-mail.

				// Powiadom użytkownika o zmianie hasła:
				echo '<h3>Hasło zostało zmienione.</h3>';
				include ('./includes/footer.html'); // Dołącz plik stopki.
				exit();

			} else { // Jeśli się nie udało.

				trigger_error('Hasło nie może zostać zmienione z powodu błędu systemu. Przepraszamy za kłopot.'); 

			}

		} else {
			
			$pass_errors['current'] = 'Bieżące hasło jest niepoprawne!';
			
		} // Koniec instrukcji ELSE bieżącego hasła.

	} // Koniec instrukcji IF $p.
	
} // Koniec głównej instrukcji warunkowej.

// Wymagany skrypt z funkcją create_form_input():
require ('./includes/form_functions.inc.php');
?><h3>Zmiana hasła</h3>
<p>Aby zmienić hasło, wypełnij formularz.</p>
<form action="change_password.php" method="post" accept-charset="utf-8">
	<p><label for="pass1"><strong>Dotychczasowe hasło</strong></label><br /><?php create_form_input('current', 'password', $pass_errors); ?></p>
	<p><label for="pass1"><strong>Nowe hasło</strong></label><br /><?php create_form_input('pass1', 'password', $pass_errors); ?> <small>Musi zawierać od 6 do 20 znaków, co najmniej jedną małą i dużą literę oraz cyfrę.</small></p>
	<p><label for="pass2"><strong>Powtórz hasło</strong></label><br /><?php create_form_input('pass2', 'password', $pass_errors); ?></p>
	<input type="submit" name="submit_button" value="Zmień &rarr;" id="submit_button" class="formbutton" />
</form>

<?php // Dołącz stopkę:
include ('./includes/footer.html');
?>
