function PersonType(name) {
    this.name = name;
}

PersonType.prototype.sayName = function() {
    console.log(this.name);
};

var person = new PersonType("Nicholas");
person.sayName();   // Dane wyjściowe to "Nicholas".

console.log(person instanceof PersonType);  // Wartość true.
console.log(person instanceof Object);      // Wartość true.


--


class PersonClass {

    // Odpowiednik konstruktora PersonType.
    constructor(name) {
        this.name = name;
    }

    // Odpowiednik PersonType.prototype.sayName.
    sayName() {
        console.log(this.name);
    }
}

let person = new PersonClass("Nicholas");
person.sayName();   // Dane wyjściowe to "Nicholas".

console.log(person instanceof PersonClass);         // Wartość true.
console.log(person instanceof Object);              // Wartość true.

console.log(typeof PersonClass);                    // "function".
console.log(typeof PersonClass.prototype.sayName);  // "function".


--


// Bezpośredni odpowiednik PersonClass.
let PersonType2 = (function() {

    "use strict";

    const PersonType2 = function(name) {

        // Upewniamy się, że funkcja została wywołana wraz ze słowem kluczowym new.
        if (typeof new.target === "undefined") {
            throw new Error("Konstruktor musi być wywołany wraz ze słowem kluczowym new.");
        }

        this.name = name;
    }

    Object.defineProperty(PersonType2.prototype, "sayName", {
        value: function() {

            // Upewniamy się, że metoda nie została wywołana wraz ze słowem kluczowym new.
            if (typeof new.target !== "undefined") {
                throw new Error("Metoda nie może być wywołana wraz ze słowem kluczowym new.");
            }

            console.log(this.name);
        },
        enumerable: false,
        writable: true,
        configurable: true
    });

    return PersonType2;
}());


--


class Foo {
   constructor() {
       Foo = "bar";    // Zgłoszenie błędu podczas wykonywania kodu…
   }
}

// Takie podejście jest dozwolone, ale po deklaracji klasy.
Foo = "baz";


--


let PersonClass = class {

    // Odpowiednik konstruktora PersonType.
    constructor(name) {
        this.name = name;
    }

    // Odpowiednik PersonType.prototype.sayName.
    sayName() {
        console.log(this.name);
    }
};

let person = new PersonClass("Nicholas");
person.sayName();   // Dane wyjściowe to "Nicholas".

console.log(person instanceof PersonClass);         // Wartość true.
console.log(person instanceof Object);              // Wartość true.

console.log(typeof PersonClass);                    // "function".
console.log(typeof PersonClass.prototype.sayName);  // "function".


--


let PersonClass = class PersonClass2 {

    // Odpowiednik konstruktora PersonType.
    constructor(name) {
        this.name = name;
    }

    // Odpowiednik PersonType.prototype.sayName.
    sayName() {
        console.log(this.name);
    }
};

console.log(typeof PersonClass);        // "function".
console.log(typeof PersonClass2);       // "undefined".


--


// Bezpośredni odpowiednik wyrażenia nazwanej klasy PersonClass.
let PersonClass = (function() {

    "use strict";

    const PersonClass2 = function(name) {

        // Upewniamy się, że funkcja została wywołana wraz ze słowem kluczowym new.
        if (typeof new.target === "undefined") {
            throw new Error("Konstruktor musi być wywołany wraz ze słowem kluczowym new.");
        }

        this.name = name;
    }

    Object.defineProperty(PersonClass2.prototype, "sayName", {
        value: function() {

            // Upewniamy się, że metoda nie została wywołana wraz ze słowem kluczowym new.
            if (typeof new.target !== "undefined") {
                throw new Error("Metoda nie może być wywołana wraz ze słowem kluczowym new.");
            }

            console.log(this.name);
        },
        enumerable: false,
        writable: true,
        configurable: true
    });

    return PersonClass2;
}());


--


function createObject(classDef) {
    return new classDef();
}

let obj = createObject(class {

    sayHi() {
        console.log("Cześć!");
    }
});

obj.sayHi();        // "Cześć!".


--


let person = new class {

    constructor(name) {
        this.name = name;
    }

    sayName() {
        console.log(this.name);
    }
}("Nicholas");

person.sayName();   // "Nicholas".


--


class CustomHTMLElement {

    constructor(element) {
        this.element = element;
    }

    get html() {
        return this.element.innerHTML;
    }

    set html(value) {
        this.element.innerHTML = value;
    }
}

var descriptor = Object.getOwnPropertyDescriptor(CustomHTMLElement.prototype, "html");
console.log("get" in descriptor);           // Wartość true.
console.log("set" in descriptor);           // Wartość true.
console.log(descriptor.enumerable);         // Wartość false.


--


// Bezpośredni odpowiednik poprzedniego przykładu.
let CustomHTMLElement = (function() {

    "use strict";

    const CustomHTMLElement = function(element) {

        // Upewniamy się, że funkcja została wywołana wraz ze słowem kluczowym new.
        if (typeof new.target === "undefined") {
            throw new Error("Konstruktor musi być wywołany wraz ze słowem kluczowym new.");
        }

        this.element = element;
    }

    Object.defineProperty(CustomHTMLElement.prototype, "html", {
        enumerable: false,
        configurable: true,
        get: function() {
            return this.element.innerHTML;
        },
        set: function(value) {
            this.element.innerHTML = value;
        }
    });

    return CustomHTMLElement;
}());


--


let methodName = "sayName";

class PersonClass {

    constructor(name) {
        this.name = name;
    }
    [methodName]() {
        console.log(this.name);
    }
};

let me = new PersonClass("Nicholas");
me.sayName();           // "Nicholas".


--


let propertyName = "html";

class CustomHTMLElement {

    constructor(element) {
        this.element = element;
    }

    get [propertyName]() {
        return this.element.innerHTML;
    }

    set [propertyName](value) {
        this.element.innerHTML = value;
    }
}


--


class MyClass {

    *createIterator() {
        yield 1;
        yield 2;
        yield 3;
    }
}

let instance = new MyClass();
let iterator = instance.createIterator();


--


class Collection {

    constructor() {
        this.items = [];
    }

    *[Symbol.iterator]() {
        yield *this.items.values();
    }
}

var collection = new Collection();
collection.items.push(1);
collection.items.push(2);
collection.items.push(3);

for (let x of collection) {
    console.log(x);
}

// Dane wyjściowe:
// 1
// 2
// 3


--


function PersonType(name) {
    this.name = name;
}

// Metoda statyczna.
PersonType.create = function(name) {
    return new PersonType(name);
};

// Metoda egzemplarza.
PersonType.prototype.sayName = function() {
    console.log(this.name);
};

var person = PersonType.create("Nicholas");


--


class PersonClass {

    // Odpowiednik konstruktora PersonType.
    constructor(name) {
        this.name = name;
    }

    // Odpowiednik PersonType.prototype.sayName.
    sayName() {
        console.log(this.name);
    }

    // Odpowiednik PersonType.create.
    static create(name) {
        return new PersonClass(name);
    }
}

let person = PersonClass.create("Nicholas");


--


function Rectangle(length, width) {
    this.length = length;
    this.width = width;
}

Rectangle.prototype.getArea = function() {
    return this.length * this.width;
};

function Square(length) {
    Rectangle.call(this, length, length);
}

Square.prototype = Object.create(Rectangle.prototype, {
    constructor: {
        value: Square,
        enumerable: true,
        writable: true,
        configurable: true
    }
});

var square = new Square(3);

console.log(square.getArea());              // 9.
console.log(square instanceof Square);      // Wartość true.
console.log(square instanceof Rectangle);   // Wartość true.


--


class Rectangle {
    constructor(length, width) {
        this.length = length;
        this.width = width;
    }

    getArea() {
        return this.length * this.width;
    }
}

class Square extends Rectangle {
    constructor(length) {

        // Odpowiednik wywołania Rectangle.call(this, length, length).
        super(length, length);
    }
}

var square = new Square(3);

console.log(square.getArea());              // 9.
console.log(square instanceof Square);      // Wartość true.
console.log(square instanceof Rectangle);   // Wartość true.


--


class Square extends Rectangle {
    // Brak konstruktora.
}

// Powyższa definicja jest odpowiednikiem poniższej.

class Square extends Rectangle {
    constructor(...args) {
        super(...args);
    }
}


--


class Square extends Rectangle {
    constructor(length) {
        super(length, length);
    }

    // Nadpisanie i przesłonięcie metody Rectangle.prototype.getArea().
    getArea() {
        return this.length * this.length;
    }
}


--


class Square extends Rectangle {
    constructor(length) {
        super(length, length);
    }

    // Nadpisanie, przesłonięcie i wywołanie metody Rectangle.prototype.getArea().
    getArea() {
        return super.getArea();
    }
}


--


class Rectangle {
    constructor(length, width) {
        this.length = length;
        this.width = width;
    }

    getArea() {
        return this.length * this.width;
    }

    static create(length, width) {
        return new Rectangle(length, width);
    }
}

class Square extends Rectangle {
    constructor(length) {

        // Odpowiednik Rectangle.call(this, length, length).
        super(length, length);
    }
}

var rect = Square.create(3, 4);

console.log(rect instanceof Rectangle);     // Wartość true.
console.log(rect.getArea());                // 12.
console.log(rect instanceof Square);        // Wartość false.


--


function Rectangle(length, width) {
    this.length = length;
    this.width = width;
}

Rectangle.prototype.getArea = function() {
    return this.length * this.width;
};

class Square extends Rectangle {
    constructor(length) {
        super(length, length);
    }
}

var x = new Square(3);
console.log(x.getArea());               // 9.
console.log(x instanceof Rectangle);    // Wartość true.


--


function Rectangle(length, width) {
    this.length = length;
    this.width = width;
}

Rectangle.prototype.getArea = function() {
    return this.length * this.width;
};

function getBase() {
    return Rectangle;
}

class Square extends getBase() {
    constructor(length) {
        super(length, length);
    }
}

var x = new Square(3);
console.log(x.getArea());               // 9.
console.log(x instanceof Rectangle);    // Wartość true.


--


let SerializableMixin = {
    serialize() {
        return JSON.stringify(this);
    }
};

let AreaMixin = {
    getArea() {
        return this.length * this.width;
    }
};

function mixin(...mixins) {
    var base = function() {};
    Object.assign(base.prototype, ...mixins);
    return base;
}

class Square extends mixin(AreaMixin, SerializableMixin) {
    constructor(length) {
        super();
        this.length = length;
        this.width = length;
    }
}

var x = new Square(3);
console.log(x.getArea());               // 9.
console.log(x.serialize());             // "{"length":3,"width":3}"


--


// Zachowanie wbudowanej tablicy.
var colors = [];
colors[0] = "czerwony";
console.log(colors.length);         // 1.

colors.length = 0;
console.log(colors[0]);             // undefined.

// Próba dziedziczenia po tablicy w specyfikacji ES5.

function MyArray() {
    Array.apply(this, arguments);
}

MyArray.prototype = Object.create(Array.prototype, {
    constructor: {
        value: MyArray,
        writable: true,
        configurable: true,
        enumerable: true
    }
});

var colors = new MyArray();
colors[0] = "czerwony";
console.log(colors.length);         // 0.

colors.length = 0;
console.log(colors[0]);             // "czerwony".


--


class MyArray extends Array {
    // Pusta definicja.
}

var colors = new MyArray();
colors[0] = "czerwony";
console.log(colors.length);         // 1.

colors.length = 0;
console.log(colors[0]);             // undefined.


--


class MyArray extends Array {
    // Pusta definicja.
}

let items = new MyArray(1, 2, 3, 4),
    subitems = items.slice(1, 3);

console.log(items instanceof MyArray);      // Wartość true.
console.log(subitems instanceof MyArray);   // Wartość true.


--


// Kilka wbudowanych typów danych używa rozwiązania podobnego do poniższego.
class MyClass {
    static get [Symbol.species]() {
        return this;
    }

    constructor(value) {
        this.value = value;
    }

    clone() {
        return new this.constructor[Symbol.species](this.value);
    }
}


--


class MyClass {
    static get [Symbol.species]() {
        return this;
    }

    constructor(value) {
        this.value = value;
    }
    clone() {
        return new this.constructor[Symbol.species](this.value);
    }
}

class MyDerivedClass1 extends MyClass {
    // Pusta definicja.
}

class MyDerivedClass2 extends MyClass {
    static get [Symbol.species]() {
        return MyClass;
    }
}

let instance1 = new MyDerivedClass1("foo"),
    clone1 = instance1.clone(),
    instance2 = new MyDerivedClass2("bar"),
    clone2 = instance2.clone();

console.log(clone1 instanceof MyClass);             // Wartość true.
console.log(clone1 instanceof MyDerivedClass1);     // Wartość true.
console.log(clone2 instanceof MyClass);             // Wartość true.
console.log(clone2 instanceof MyDerivedClass2);     // Wartość false.


--


class MyArray extends Array {
    static get [Symbol.species]() {
        return Array;
    }
}

let items = new MyArray(1, 2, 3, 4),
    subitems = items.slice(1, 3);

console.log(items instanceof MyArray);              // Wartość true.
console.log(subitems instanceof Array);             // Wartość true.
console.log(subitems instanceof MyArray);           // Wartość false.


--


class Rectangle {
    constructor(length, width) {
        console.log(new.target === Rectangle);
        this.length = length;
        this.width = width;
    }
}

// Właściwość new.target ma wartość Rectangle.
var obj = new Rectangle(3, 4);      // Dane wyjściowe to true.


--


class Rectangle {
    constructor(length, width) {
        console.log(new.target === Rectangle);
        this.length = length;
        this.width = width;
    }
}

class Square extends Rectangle {
    constructor(length) {
        super(length, length)
    }
}

// Właściwość new.target ma wartość Square.
var obj = new Square(3);      // Dane wyjściowe to false.


--


// Abstrakcyjna klasa bazowa.
class Shape {
    constructor() {
        if (new.target === Shape) {
            throw new Error("Nie można bezpośrednio utworzyć egzemplarzy tej klasy.")
        }
    }
}

class Rectangle extends Shape {
    constructor(length, width) {
        super();
        this.length = length;
        this.width = width;
    }
}

var x = new Shape();                // Następuje zgłoszenie błędu.

var y = new Rectangle(3, 4);        // Bez błędu.
console.log(y instanceof Shape);    // Wartość true.
