let text = "𠮷";

console.log(text.length);           // 2.
console.log(/^.$/.test(text));      // Wartość false.
console.log(text.charAt(0));        // "".
console.log(text.charAt(1));        // "".
console.log(text.charCodeAt(0));    // 55362.
console.log(text.charCodeAt(1));    // 57271.


--


let text = "𠮷a";

console.log(text.charCodeAt(0));    // 55362.
console.log(text.charCodeAt(1));    // 57271.
console.log(text.charCodeAt(2));    // 97.

console.log(text.codePointAt(0));   // 134071.
console.log(text.codePointAt(1));   // 57271.
console.log(text.codePointAt(2));   // 97.


--


function is32Bit(c) {
    return c.codePointAt(0) > 0xFFFF;
}

console.log(is32Bit("𠮷"));         // Wartość true.
console.log(is32Bit("a"));          // Wartość false.


--


let normalized = values.map(function(text) {
    return text.normalize();
});

normalized.sort(function(first, second) {
    if (first < second) {
        return -1;
    } else if (first === second) {
        return 0;
    } else {
        return 1;
    }
});


--


values.sort(function(first, second) {
    let firstNormalized = first.normalize(),
        secondNormalized = second.normalize();

    if (firstNormalized < secondNormalized) {
        return -1;
    } else if (firstNormalized === secondNormalized) {
        return 0;
    } else {
        return 1;
    }
});


--


values.sort(function(first, second) {
    let firstNormalized = first.normalize("NFD"),
        secondNormalized = second.normalize("NFD");

    if (firstNormalized < secondNormalized) {
        return -1;
    } else if (firstNormalized === secondNormalized) {
        return 0;
    } else {
        return 1;
    }
});


--


let text = "𠮷";

console.log(text.length);           // 2.
console.log(/^.$/.test(text));      // Wartość false.
console.log(/^.$/u.test(text));     // Wartość true.


--


function codePointLength(text) {
    let result = text.match(/[\s\S]/gu);
    return result ? result.length : 0;
}

console.log(codePointLength("abc"));    // 3.
console.log(codePointLength("𠮷bc"));   // 3.


--


function hasRegExpU() {
    try {
        var pattern = new RegExp(".", "u");
        return true;
    } catch (ex) {
        return false;
    }
}


--


let msg = "Witaj, świecie!";

console.log(msg.startsWith("Witaj"));       // Wartość true.
console.log(msg.endsWith("!"));             // Wartość true.
console.log(msg.includes("j"));             // Wartość true.

console.log(msg.startsWith("j"));           // Wartość false.
console.log(msg.endsWith("świecie!"));      // Wartość true.
console.log(msg.includes("x"));             // Wartość false.

console.log(msg.startsWith("j", 4));        // Wartość true.
console.log(msg.endsWith("j", 11));         // Wartość true.
console.log(msg.includes("j", 11));         // Wartość false.


--


console.log("x".repeat(3));         // "xxx".
console.log("witaj".repeat(2));     // "witajwitajwitaj".
console.log("abc".repeat(4));       // "abcabcabcabc".


--


// Wcięcie zawierające podaną liczbę spacji.
let indent = " ".repeat(4),
    indentLevel = 0;

// Kiedy trzeba zwiększyć wcięcie, wtedy należy użyć poniższego polecenia.
let newIndent = indent.repeat(++indentLevel);


--


let text = "witaj1 witaj2 witaj3",
    pattern = /witaj\d\s?/,
    result = pattern.exec(text),
    globalPattern = /witaj\d\s?/g,
    globalResult = globalPattern.exec(text),
    stickyPattern = /witaj\d\s?/y,
    stickyResult = stickyPattern.exec(text);

console.log(result[0]);         // "witaj1 ".
console.log(globalResult[0]);   // "witaj1 ".
console.log(stickyResult[0]);   // "witaj1 ".

pattern.lastIndex = 1;
globalPattern.lastIndex = 1;
stickyPattern.lastIndex = 1;

result = pattern.exec(text);
globalResult = globalPattern.exec(text);
stickyResult = stickyPattern.exec(text);

console.log(result[0]);         // "witaj1 ".
console.log(globalResult[0]);   // "witaj2 ".
console.log(stickyResult[0]);   // Następuje zgłoszenie błędu!


--


let text = "witaj1 witaj2 witaj3",
    pattern = /witaj\d\s?/,
    result = pattern.exec(text),
    globalPattern = /witaj\d\s?/g,
    globalResult = globalPattern.exec(text),
    stickyPattern = /witaj\d\s?/y,
    stickyResult = stickyPattern.exec(text);

console.log(result[0]);         // "witaj1 ".
console.log(globalResult[0]);   // "witaj1 ".
console.log(stickyResult[0]);   // "witaj1 ".

console.log(pattern.lastIndex);         // 0.
console.log(globalPattern.lastIndex);   // 7.
console.log(stickyPattern.lastIndex);   // 7.

result = pattern.exec(text);
globalResult = globalPattern.exec(text);
stickyResult = stickyPattern.exec(text);

console.log(result[0]);         // "witaj1 ".
console.log(globalResult[0]);   // "witaj2 ".
console.log(stickyResult[0]);   // "witaj2 ".

console.log(pattern.lastIndex);         // 0.
console.log(globalPattern.lastIndex);   // 14.
console.log(stickyPattern.lastIndex);   // 14.


--


let pattern = /witaj\d/y;
console.log(pattern.sticky);    // Wartość true.


--


function hasRegExpY() {
    try {
        var pattern = new RegExp(".", "y");
        return true;
    } catch (ex) {
        return false;
    }
}
function hasRegExpY() {
    try {
        var pattern = new RegExp(".", "y");
        return true;
    } catch (ex) {
        return false;
    }
}


--


var re1 = /ab/i,
    re2 = new RegExp(re1);


--


var re1 = /ab/i,
    // Następuje zgłoszenie błędu w ES5, natomiast w ES6 kod działa bez problemów.
    re2 = new RegExp(re1, "g");


--


let re1 = /ab/i,

    // Następuje zgłoszenie błędu w ES5, natomiast w ES6 kod działa bez problemów.
    re2 = new RegExp(re1, "g");

console.log(re1.toString());            // "/ab/i".
console.log(re2.toString());            // "/ab/g".

console.log(re1.test("ab"));            // Wartość true.
console.log(re2.test("ab"));            // Wartość true.

console.log(re1.test("AB"));            // Wartość true.
console.log(re2.test("AB"));            // Wartość false.


--


function getFlags(re) {
    var text = re.toString();
    return text.substring(text.lastIndexOf("/") + 1, text.length);
}

// Wartość przekazana metodzie toString() to "/ab/g".
var re = /ab/g;

console.log(getFlags(re));          // "g".


--


let re = /ab/g;

console.log(re.source);     // "ab".
console.log(re.flags);      // "g".


--


let message = `Witaj, świecie!`;

console.log(message);               // "Witaj, świecie!".
console.log(typeof message);        // "string".
console.log(message.length);        // 15.
let message = `Witaj, świecie!`;

console.log(message);               // "Witaj, świecie!".
console.log(typeof message);        // "string".
console.log(message.length);        // 15.


--


let message = `\`Witaj\` świecie!`;
console.log(message);               // "`Witaj` świecie!".
console.log(typeof message);        // "string".
console.log(message.length);        // 17.


--


var message = "Wielowierszowy \
ciąg tekstowy";
console.log(message);       // "Wielowierszowy ciąg tekstowy".


--


var message = "Wielowierszowy \n\
ciąg tekstowy";
console.log(message);       // "Wielowierszowy
                            //  ciąg tekstowy".


--


var message = [
    "Wielowierszowy ",
    "ciąg tekstowy"
].join("\n");

let message = "Wielowierszowy \n" +
    "ciąg tekstowy";


--


let message = `Wielowierszowy
ciąg tekstowy`;

console.log(message);           // "Wielowierszowy
                                //  ciąg tekstowy".
console.log(message.length);    // 16.


--


let message = `Wielowierszowy
               ciąg tekstowy`;

console.log(message);           // "Wielowierszowy
                                //                 ciąg tekstowy".
console.log(message.length);    // 31.


--


let html = `
<div>
    <h1>Tytuł</h1>
</div>`.trim();


--


let message = `Wielowierszowy\nciąg tekstowy`;

console.log(message);           // "Wielowierszowy
                                //  ciąg tekstowy".
console.log(message.length);    // 16.


--


let name = "Nicholas",
    message = `Witaj, ${name}.`;
console.log(message);       // "Witaj, Nicholas."


--


let count = 10,
    price = 0.25,
    message = `${count} produktów kosztuje ${(count * price).toFixed(2)} zł.`;
console.log(message);       // "10 produktów kosztuje 2.50 zł.".


--


let name = "Nicholas",
    message = `Witaj, ${
        `mam na imię ${ name }`
    }.`;

console.log(message);        // "Witaj, mam na imię Nicholas.".


--


function tag(literals, ...substitutions) {
    // Wartością zwrotną jest ciąg tekstowy.
}


--


let count = 10,
    price = 0.25,
    message = passthru`${count} produktów kosztuje ${(count * price).toFixed(2)} zł.`;


--


function passthru(literals, ...substitutions) {
    let result = "";
    // Wykonanie pętli jedynie w celu zliczenia zastąpień.
    for (let i = 0; i < substitutions.length; i++) {
        result += literals[i];
        result += substitutions[i];
    }
    // Dodanie ostatniego literału.
    result += literals[literals.length - 1];
    return result;
}
let count = 10,
    price = 0.25,
    message = passthru`${count} produktów kosztuje ${(count * price).toFixed(2)} zł.`;
console.log(message);       // "10 produktów kosztuje 2.50 zł.".


--


let message1 = `Wielowierszowy\nciąg tekstowy`,
    message2 = String.raw`Wielowierszowy\nciąg tekstowy`;

console.log(message1);          // "Wielowierszowy
                                //  ciąg tekstowy".
console.log(message2);          // "Wielowierszowy\\nciąg tekstowy".


--


function raw(literals, ...substitutions) {
    let result = "";
    // Wykonanie pętli jedynie w celu zliczenia zastąpień.
    for (let i = 0; i < substitutions.length; i++) {
        // Użycie niezmodyfikowanych wartości tablic.
        result += literals.raw[i];      
        result += substitutions[i];
    }
    // Dodanie ostatniego literału.
    result += literals.raw[literals.length - 1];
    return result;
}

let message = raw`Wielowierszowy\nciąg tekstowy`;

console.log(message);           // "Wielowierszowy\\nciąg tekstowy".
console.log(message.length);    // 29.
