let items = new Array(2);
console.log(items.length);          // 2.
console.log(items[0]);              // undefined.
console.log(items[1]);              // undefined.

items = new Array("2");
console.log(items.length);          // 1.
console.log(items[0]);              // "2".

items = new Array(1, 2);
console.log(items.length);          // 2.
console.log(items[0]);              // 1.
console.log(items[1]);              // 2.

items = new Array(3, "2");
console.log(items.length);          // 2.
console.log(items[0]);              // 3.
console.log(items[1]);              // "2".


--


let items = Array.of(1, 2);
console.log(items.length);          // 2.
console.log(items[0]);              // 1.
console.log(items[1]);              // 2.

items = Array.of(2);
console.log(items.length);          // 1.
console.log(items[0]);              // 2.
items = Array.of("2");
console.log(items.length);          // 1.
console.log(items[0]);              // "2".


--


function createArray(arrayCreator, value) {
    return arrayCreator(value);
}

let items = createArray(Array.of, value);


--


function makeArray(arrayLike) {
    var result = [];

    for (var i = 0, len = arrayLike.length; i < len; i++) {
        result.push(arrayLike[i]);
    }

    return result;
}
function doSomething() {
    var args = makeArray(arguments);

    // Użycie obiektu args.
}


--


function makeArray(arrayLike) {
    return Array.prototype.slice.call(arrayLike);
}

function doSomething() {
    var args = makeArray(arguments);

    // Użycie obiektu args.
}


--


function doSomething() {
    var args = Array.from(arguments);

    // Użycie obiektu args.
}


--


function translate() {
    return Array.from(arguments, (value) => value + 1);
}

let numbers = translate(1, 2, 3);

console.log(numbers);               // 2,3,4.


--


let helper = {
    diff: 1,

    add(value) {
        return value + this.diff;
    }
};

function translate() {
    return Array.from(arguments, helper.add, helper);
}

let numbers = translate(1, 2, 3);

console.log(numbers);               // 2,3,4.


--


let numbers = {
    *[Symbol.iterator]() {
        yield 1;
        yield 2;
        yield 3;
    }
};

let numbers2 = Array.from(numbers, (value) => value + 1);

console.log(numbers2);              // 2,3,4.


--


let numbers = [25, 30, 35, 40, 45];

console.log(numbers.find(n => n > 33));         // 35.
console.log(numbers.findIndex(n => n > 33));    // 2.


--


let numbers = [1, 2, 3, 4];

numbers.fill(1);

console.log(numbers.toString());    // 1,1,1,1.


--


let numbers = [1, 2, 3, 4];

numbers.fill(1, 2);

console.log(numbers.toString());    // 1,2,1,1.

numbers.fill(0, 1, 3);

console.log(numbers.toString());    // 1,0,0,1.


--


let numbers = [1, 2, 3, 4];

// Wklejenie wartości w tablicy, począwszy od indeksu 2.
// Skopiowanie wartości z tablicy, począwszy od indeksu 0.
numbers.copyWithin(2, 0);

console.log(numbers.toString());    // 1,2,1,2.


--


let numbers = [1, 2, 3, 4];

// Wklejenie wartości w tablicy, począwszy od indeksu 2.
// Skopiowanie wartości z tablicy, począwszy od indeksu 0.
// Zatrzymanie kopiowania wartości po dotarciu do indeksu  1.
numbers.copyWithin(2, 0, 1);

console.log(numbers.toString());    // 1,2,1,4.


--


let buffer = new ArrayBuffer(10);   // Alokacja 10 bajtów.
console.log(buffer.byteLength);     // 10.


--


let buffer = new ArrayBuffer(10);   // Alokacja 10 bajtów.
let buffer2 = buffer.slice(4, 6);
console.log(buffer2.byteLength);    // 2.


--


let buffer = new ArrayBuffer(10),
    view = new DataView(buffer);


--


let buffer = new ArrayBuffer(10),
    view = new DataView(buffer, 5, 2);      // Obejmuje bajty 5 i 6.


--


let buffer = new ArrayBuffer(10),
    view1 = new DataView(buffer),           // Obejmuje wszystkie bajty.
    view2 = new DataView(buffer, 5, 2);     // Obejmuje bajty 5 i 6.

console.log(view1.buffer === buffer);       // Wartość true.
console.log(view2.buffer === buffer);       // Wartość true.
console.log(view1.byteOffset);              // 0.
console.log(view2.byteOffset);              // 5.
console.log(view1.byteLength);              // 10.
console.log(view2.byteLength);              // 2.


--


let buffer = new ArrayBuffer(2),
    view = new DataView(buffer);

view.setInt8(0, 5);
view.setInt8(1, -1);

console.log(view.getInt8(0));       // 5.
console.log(view.getInt8(1));       // –1.


--


let buffer = new ArrayBuffer(2),
    view = new DataView(buffer);

view.setInt8(0, 5);
view.setInt8(1, -1);

console.log(view.getInt16(0));      // 1535.
console.log(view.getInt8(0));       // 5.
console.log(view.getInt8(1));       // –1.


--


let buffer = new ArrayBuffer(10),
    view1 = new Int8Array(buffer),
    view2 = new Int8Array(buffer, 5, 2);

console.log(view1.buffer === buffer);       // Wartość true.
console.log(view2.buffer === buffer);       // Wartość true.
console.log(view1.byteOffset);              // 0.
console.log(view2.byteOffset);              // 5.
console.log(view1.byteLength);              // 10.
console.log(view2.byteLength);              // 2.


--


let ints = new Int16Array(2),
    floats = new Float32Array(5);

console.log(ints.byteLength);       // 4.
console.log(ints.length);           // 2.

console.log(floats.byteLength);     // 20.
console.log(floats.length);         // 5.


--


let ints1 = new Int16Array([25, 50]),
    ints2 = new Int32Array(ints1);

console.log(ints1.buffer === ints2.buffer);     // Wartość false.

console.log(ints1.byteLength);      // 4.
console.log(ints1.length);          // 2.
console.log(ints1[0]);              // 25.
console.log(ints1[1]);              // 50.

console.log(ints2.byteLength);      // 8.
console.log(ints2.length);          // 2.
console.log(ints2[0]);              // 25.
console.log(ints2[1]);              // 50.


--


console.log(UInt8Array.BYTES_PER_ELEMENT);      // 1.
console.log(UInt16Array.BYTES_PER_ELEMENT);     // 2.

let ints = new Int8Array(5);
console.log(ints.BYTES_PER_ELEMENT);            // 1.


--


let ints = new Int16Array([25, 50]);

console.log(ints.length);          // 2.
console.log(ints[0]);              // 25.
console.log(ints[1]);              // 50.

ints[0] = 1;
ints[1] = 2;

console.log(ints[0]);              // 1.
console.log(ints[1]);              // 2.


--


let ints = new Int16Array([25, 50]),
    mapped = ints.map(v => v * 2);

console.log(mapped.length);        // 2.
console.log(mapped[0]);            // 50.
console.log(mapped[1]);            // 100.

console.log(mapped instanceof Int16Array);  // Wartość true.


--


let ints = new Int16Array([25, 50]),
    intsArray = [...ints];

console.log(intsArray instanceof Array);    // Wartość true.
console.log(intsArray[0]);                  // 25.
console.log(intsArray[1]);                  // 50.


--


let ints = Int16Array.of(25, 50),
    floats = Float32Array.from([1.5, 2.5]);

console.log(ints instanceof Int16Array);        // Wartość true.
console.log(floats instanceof Float32Array);    // Wartość true.
console.log(ints.length);       // 2.
console.log(ints[0]);           // 25.
console.log(ints[1]);           // 50.

console.log(floats.length);     // 2.
console.log(floats[0]);         // 1.5.
console.log(floats[1]);         // 2.5.


--


let ints = new Int16Array([25, 50]);

console.log(ints instanceof Array);     // Wartość false.
console.log(Array.isArray(ints));       // Wartość false.


--


let ints = new Int16Array([25, 50]);

console.log(ints.length);          // 2.
console.log(ints[0]);              // 25.
console.log(ints[1]);              // 50.

ints[2] = 5;

console.log(ints.length);          // 2.
console.log(ints[2]);              // undefined.


--


let ints = new Int16Array(["cześć"]);

console.log(ints.length);       // 1.
console.log(ints[0]);           // 0.


--


let ints = new Int16Array([25, 50]),
    mapped = ints.map(v => "cześć");

console.log(mapped.length);        // 2.
console.log(mapped[0]);            // 0.
console.log(mapped[1]);            // 0.

console.log(mapped instanceof Int16Array);  // Wartość true.
console.log(mapped instanceof Array);       // Wartość false.


--


let ints = new Int16Array(4);

ints.set([25, 50]);
ints.set([75, 100], 2);

console.log(ints.toString());   // 25,50,75,100.


--


let ints = new Int16Array([25, 50, 75, 100]),
    subints1 = ints.subarray(),
    subints2 = ints.subarray(2),
    subints3 = ints.subarray(1, 3);

console.log(subints1.toString());   // 25,50,75,100.
console.log(subints2.toString());   // 75,100.
console.log(subints3.toString());   // 50,75.
