/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package org.eclipsewtp.wsdlextensions;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Node;

public class SOAPLabelProvider extends LabelProvider {
  private Image bindingImage = Activator.imageDescriptorFromPlugin(
		  "org.eclipsewtp.wsdlextensions", "icons/soapbinding.gif")
		  .createImage();

  public Image getImage(Object element) {
    Node node = (Node)element;
    String elementName = node.getLocalName();
    if("binding".equals(elementName))
      return bindingImage;
    return null;
  }
  
  public void dispose() {
    bindingImage.dispose();
  }
}
